
package lecture03;

import java.util.Date;

/**
 * This class represents a print job (simulating a
 * print job that is sent to a remote printer from
 * a personal computer). 
 * 
 * @author Joanna Klukowska
 * @version Feb 10, 2014 
 *
 */
public class PrintJob {
	protected int numOfPages;
	protected int numPagesLeft;
	protected String user;
	protected long timeReceived;
	protected long timeCompleted;
	
	/**
	 * Construct a ProntJob object given username of the user 
	 * who created it and number of pages.
	 * @param numOfPages
	 * 	   number of pages that the job consists of
	 * @param user
	 *     username of the user who requested a print job
	 */
	public PrintJob(int numOfPages, String user) {
		this.numOfPages = numOfPages;
		numPagesLeft = numOfPages;
		this.user = user;
		timeReceived = new Date().getTime();
		timeCompleted = 0;
	}

	/* 
	 * Sets the completion time to the current time.
	 * For internal use only.
	 */
	protected void setCompleted( ) {
		this.timeCompleted =  new Date().getTime();
	}
	
	/**
	 * Simulates the printing of a single page.
	 * If the number of pages left to print is 
	 * greater than zero, it is decremented by one.
	 * If the number of pages left to print reaches zero, 
	 * the job is set to completed.
	 */
	public void printPage( ) {
		if (numPagesLeft > 0) {
			numPagesLeft--;
			if (numPagesLeft == 0)
				setCompleted();
		}
	}
	
	/**
	 * Determines how long it took for the job to complete (including the
	 * wait time in the queue).
	 * @return
	 *   The number of milliseconds it took from the moment the job
	 *   entered the print queue to the moment it was completed.
	 */
	public long getTimeUsed( ) {
		if (timeCompleted != 0)
			return timeCompleted - timeReceived;
		else 
			return -1;
	}
	
	/**
	 * Determines if a job is finished or not.
	 * @return
	 *   true if all pages were printed
	 *   false otherwise 
	 */
	public boolean isCompleted () {
		if (timeCompleted == 0 )
			return false;
		else 
			return true;
	}

	/**
	 * Returns the total number of pages in a print job.
	 * @return the numOfPages
	 */
	public int getNumOfPages() {
		return numOfPages;
	}

	/**
	 * Returns the number of still unprinted pages in a print job.
	 * @return the numPagesLeft
	 */
	public int getNumPagesLeft() {
		return numPagesLeft;
	}

	/**
	 * Returns the user name associated with a print job.
	 * @return the user
	 */
	public String getUser() {
		return user;
	}

	/**
	 * Returns the time received (as number of seconds since Jan. 1, 1970
	 * @return the timeReceived
	 */
	public long getTimeReceived() {
		return timeReceived;
	}
	
	
	
	
	

}
