/**
 * 
 */
package lecture03;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;

/**
 * This class provides a program that tests if the input file provided as an argument 
 * has matching brackets (among other text) or not. 
 * 
 * @author Joanna Klukowska
 * @version Feb 5, 2014 
 *
 */
public class CheckMatchingBrackets {

	/**
	 * @param args 
	 *   A single argument is a file name that is checked for matched brackets.
	 * @throws FileNotFoundException 
	 */
	public static void main(String[] args) throws FileNotFoundException {
		

	    // Check command line parameter usage
	    if (args.length < 1) {
	      System.err.printf(
	        "Usage: java CheckMatchingBrackets sourceFile%n");
	      System.exit(1);
	    }
		
	    // Check if source file exists
	    File sourceFile = new File(args[0]);
	    if (!sourceFile.exists()) {
	      System.out.println("Source file " + args[0] + " does not exist");
	      System.exit(2);
	    }
	    
	    // Associate input file with the Scanner object
	    Scanner input = new Scanner(sourceFile);
	    
	    StringBuffer fileToParse = new StringBuffer();
	    String line; 
	    
	    //read in the content of the entire file
		while (input.hasNext() ) {
			line = input.nextLine();
			fileToParse.append(line);
		}
		
		boolean isValid = testMatchingBrackets( fileToParse );
		
		if ( isValid )
			System.out.printf("The input file contains matched brackets.%n");
		else 
			System.err.printf("ERROR: The input file contains unmatched brackets.%n");
		
		input.close();
		
	}

	/**
	 * Determine if the string passed as a paramer contains
	 * matching brackets or not.
	 * @param fileToParse 
	 *    String that contains text to be tested for the
	 *    matching brackets.
	 * @return
	 *    true, if the fileToParse contains only matching brackets.
	 *    false, if it contains unmatched brackets.
	 */
	private static boolean testMatchingBrackets(StringBuffer fileToParse) {
		//stack to hold unmatched open brackets
		CharStack unmatchedOpenBrackets = new CharStackArray();
		char currentChar;
		for (int i = 0; i < fileToParse.length(); i++ ) {
			
			currentChar = fileToParse.charAt(i);
			
			//if the current character is an opening
			//bracket, add it to the stack
			if ( isOpenBracket( currentChar )){
				System.out.println(unmatchedOpenBrackets);
				
				unmatchedOpenBrackets.push(currentChar);
				
			}
			
			//if it is a closing bracket, check if the bracket
			//at the top of the stack matches it;
			//if it does, keep going, otherwise string is not valid
			if ( isClosedBracket ( currentChar) ) {
				System.out.println(unmatchedOpenBrackets);
				System.out.println(unmatchedOpenBrackets.peek()+ "  " + currentChar  );
				if ( !areMatchingBrackets( unmatchedOpenBrackets.pop(), currentChar) )
					return false;
			}
			//if the character is anything else, ignore it
			
		}
		//if the stack is empty at this point, the string is valid,
		//otherwise it has unmatched brackets
		if ( unmatchedOpenBrackets.pop() == null ) 
			return true;
		else
			return false;
	}

	/**
	 * Determine if character passed as a parameter is an open bracket.
	 * @param c
	 *   character to be tested
	 * @return
	 *   true if c is an open bracket: (, { or [
	 *   false if it is any other character
	 */
	private static boolean isOpenBracket(char c) {
		if (c == '(' || c == '{' || c == '['  )
			return true;
		return false;
	}



	/**
	 * Determine if character passed as a parameter is a close bracket.
	 * @param c
	 *   character to be tested
	 * @return
	 *   true if c is a close bracket: ), } or ]
	 *   false if it is any other character
	 */
	private static boolean isClosedBracket(char c) {
		if (c == ')' || c == '}' || c == ']'  )
			return true;
		return false;
	}
	

	/**
	 * Determines if the characters passed as parameters
	 * are a set of matching open and close brackets
	 * @param open
	 *   character that is potentially an open bracket
	 * @param close
	 *   character that is potentially a close bracket
	 * @return
	 *   true, if the characters are brackets and are matching
	 *   false, otherwise
	 */
	private static boolean areMatchingBrackets(Character open, Character close) {
		if (open == null || close == null)
			return false;
		if (       ( open == '(' && close == ')' )
				|| ( open == '{' && close == '}' )
				|| ( open == '[' && close == ']' )
		   )
			return true;
		return false;
	}
	
	

	
}
