/**
 * 
 */
package lecture03;

/**
 * Implementation of a stack of Characters that uses an array for internal storage. 
 * @author Joanna Klukowska
 * @version Feb 5, 2014 
 *
 */
public class CharStackArray implements CharStack {


	private Character [] list;
	private int size;
	private int capacity;
	private static int DEFAULT_CAPACITY = 16;
	
	/**
	 * Constructs an empty stack of characters with a specified capacity 
	 * (if provided capacity is less than or equal to zero, the capacity 
	 * is set to default 16).
	 * @param capacity current capacity of an array for storing characters
	 */
	public CharStackArray( int capacity )
	{
		//if capacity is negative or zero, reset it to 
		//default value
		if (capacity <= 0 ) capacity = DEFAULT_CAPACITY;
	
		//allocate the array for storing characters
		list = new Character [capacity];
		
		//set the initial values
		size = 0;
		this.capacity = capacity;	
	}
	
	/**
	 * Constructs an empty stack of characters with a default capacity of 16.
	 */
	public CharStackArray( )
	{
		this(DEFAULT_CAPACITY);
	}
	 
	
	
	/* (non-Javadoc)
	 * @see lecture03.CharStackInterface#push(java.lang.Character)
	 */
	@Override
	public void push(Character item) {

		//if the stack is full, allocate a larger array
		if (  size == capacity )
			makeLarger();
		//add the new value to the top of the stack
		if (item != null) {
			list[size] = item;
			size++;
		}
	}

	/* (non-Javadoc)
	 * @see lecture03.CharStackInterface#pop()
	 */
	@Override
	public Character pop() {
		//System.out.println(size);
		//if stack is empty return null reference
		if ( size == 0 ) return null;
		//otherwise remove and return character from the top of the stack
		else {
			size--;
			return list[size];
		}
	}

	/* (non-Javadoc)
	 * @see lecture03.CharStackInterface#peak()
	 */
	@Override
	public Character peek() {

		//if stack is empty return null reference
		if ( size == 0 ) return null;
		//otherwise remove and return character from the top of the stack
		else {
			return list[size-1];
		}
	}
	
	/*
	 * Allocates an array twice the size of the current array used for 
	 * storing the stack and copies all the data to the new array.
	 */
	private void makeLarger ()
	{
		//allocate larger array
		Character [] newList = new Character [capacity * 2 ];
		//copy the data over to the new array
		for (int i = 0; i < capacity; i++)
		{
			newList[i] = list[i];
		}
		//reset list reference to the new array
		list = newList;
		//reset the capacity to the new value
		capacity = 2*capacity;
		
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		//prints the stack as a string 
		//"stack(size): space separated elements"
		StringBuffer stack = new StringBuffer();
		stack.append( "stack(" +size + "): " ); 
		for (int i = 0; i < size; i++ ) {
			stack.append( list[i] + " " );
		}
		return stack.toString();
	}

}
