/**
 * 
 */
package lecture03;

/**
 * An interface for a stack of Character objects. 
 * 
 * @author Joanna Klukowska
 * @version Feb 5, 2014 
 *
 */
public interface CharStack {

	/**
	 * Add a Character object to the top of the stack
	 * @param item
	 *   character to be added to the stack
	 */  
	public void push ( Character item ) ;
	
	/**
	 * Remove and return a Character object from the top of the stack
	 * @return
	 *   Character from the top of the stack is returned and removed 
	 *   from the stack. If stack is empty, null is returned.
	 */
	public Character pop () ;
	
	/**
	 * Return a Character object from the top of the stack.
	 * @return
	 *   Character from the top of the stack is returned. 
	 *   If stack is empty, null is returned.
	 */
	public Character peek () ;
	
	
	/**
	 * Produces string representation of the stack.
	 * @return
	 *   Returns a String object that contains all characters
	 *   stored on the stack. Character objects are separated 
	 *   by spaces. The top of the stack is the rightmost character
	 *   in the returned string.
	 */
	
	public String toString () ;
}
