
package lecture03;

/**
 * 
 * @author Joanna Klukowska
 * @version Mar 2, 2014 
 *
 */
public class Car {
	private String make;
	private int year;
	
	/**
	 * Creates a car object.
	 * @param make
	 *    specifies make of the car
	 * @param year
	 *    specifies year of the car
	 */
	public Car(String make, int year) {
		this.make = make;
		this.year = year;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Car [make=" + make + ", year=" + year + "]";
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Car other = (Car) obj;
		if (make == null) {
			if (other.make != null)
				return false;
		} else if (!make.equals(other.make))
			return false;
		if (year != other.year)
			return false;
		return true;
	}
	

	
	
}
