package lecture01;

/**
 * This program demonstrates inheritance of
 * the static data fields and methods. 
 * -- When a static method is called with the class
 * a method specific to that class runs (this is the 
 * standard behavior that does not depend
 * on inheritance).
 * -- When a static method is called on an instance,
 * then the method that runs depends on the declared
 * type of the instance (the type of the reference,
 * not the type of the object).
 * -- When an instance method is called on an instance,
 * then the method that runs depends on the actual
 * type of the instance (the type of the object, not the 
 * type of the reference - this is dynamic binding). 
 * 
 * @author Joanna Klukowska
 *
 */
public class Cat extends Animal {
    public static void testClassMethod() {
        System.out.println("The static method in Cat");
    }
    public void testInstanceMethod() {
        System.out.println("The instance method in Cat");
    }

    public static void main(String[] args) {
        Cat myCat = new Cat();
        Animal myAnimal = myCat;
        //when the static method is called using the class name 
        //the behavior is as expected
        Cat.testClassMethod();
        Animal.testClassMethod();
        //when we call a static/class method using the reference variable 
        //(which is generally not a good idea, but possible)
        //the static method that runs is decided based on the DECLARED  
        //type of the reference 
        myCat.testClassMethod();
        myAnimal.testClassMethod();
        //when we call an instance method using the reference variable
        //the instance method that runs is decided based on the ACTUAL 
        //type of the reference 
        myCat.testInstanceMethod();
        myAnimal.testInstanceMethod();
    }
}


class Animal {
    public static void testClassMethod() {
        System.out.println("The static method in Animal");
    }
    public void testInstanceMethod() {
        System.out.println("The instance method in Animal");
    }
}