/*
 * Copyright (c) 2012, 2014, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.nl;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_nl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "001", "Wereld" },
            { "002", "Afrika" },
            { "003", "Noord-Amerika" },
            { "005", "Zuid-Amerika" },
            { "009", "Oceani\u00eb" },
            { "011", "West-Afrika" },
            { "013", "Midden-Amerika" },
            { "014", "Oost-Afrika" },
            { "015", "Noord-Afrika" },
            { "017", "Centraal-Afrika" },
            { "018", "Zuidelijk Afrika" },
            { "019", "Amerika" },
            { "021", "Noordelijk Amerika" },
            { "029", "Caribisch gebied" },
            { "030", "Oost-Azi\u00eb" },
            { "034", "Zuid-Azi\u00eb" },
            { "035", "Zuidoost-Azi\u00eb" },
            { "039", "Zuid-Europa" },
            { "053", "Australi\u00eb en Nieuw-Zeeland" },
            { "054", "Melanesi\u00eb" },
            { "057", "Micronesische regio" },
            { "061", "Polynesi\u00eb" },
            { "142", "Azi\u00eb" },
            { "143", "Centraal-Azi\u00eb" },
            { "145", "West-Azi\u00eb" },
            { "150", "Europa" },
            { "151", "Oost-Europa" },
            { "154", "Noord-Europa" },
            { "155", "West-Europa" },
            { "419", "Latijns-Amerika" },
            { "AC", "Ascension" },
            { "AD", "Andorra" },
            { "AE", "Verenigde Arabische Emiraten" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua en Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albani\u00eb" },
            { "AM", "Armeni\u00eb" },
            { "AN", "Nederlandse Antillen" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentini\u00eb" },
            { "AS", "Amerikaans Samoa" },
            { "AT", "Oostenrijk" },
            { "AU", "Australi\u00eb" },
            { "AW", "Aruba" },
            { "AX", "\u00c5landeilanden" },
            { "AZ", "Azerbeidzjan" },
            { "BA", "Bosni\u00eb en Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgi\u00eb" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarije" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BR", "Brazili\u00eb" },
            { "BS", "Bahama\u2019s" },
            { "BT", "Bhutan" },
            { "BV", "Bouveteiland" },
            { "BW", "Botswana" },
            { "BY", "Wit-Rusland" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Cocoseilanden" },
            { "CD", "Congo-Kinshasa" },
            { "CF", "Centraal-Afrikaanse Republiek" },
            { "CG", "Congo-Brazzaville" },
            { "CH", "Zwitserland" },
            { "CI", "Ivoorkust" },
            { "CK", "Cookeilanden" },
            { "CL", "Chili" },
            { "CM", "Kameroen" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Clipperton" },
            { "CR", "Costa Rica" },
            { "CS", "Servi\u00eb en Montenegro" },
            { "CU", "Cuba" },
            { "CV", "Kaapverdi\u00eb" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmaseiland" },
            { "CY", "Cyprus" },
            { "CZ", "Tsjechi\u00eb" },
            { "DE", "Duitsland" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Denemarken" },
            { "DM", "Dominica" },
            { "DO", "Dominicaanse Republiek" },
            { "DZ", "Algerije" },
            { "EA", "Ceuta en Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estland" },
            { "EG", "Egypte" },
            { "EH", "Westelijke Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Spanje" },
            { "ET", "Ethiopi\u00eb" },
            { "EU", "Europese Unie" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falklandeilanden" },
            { "FM", "Micronesi\u00eb" },
            { "FO", "Faer\u00f6er" },
            { "FR", "Frankrijk" },
            { "FX", "Europese Frankrijk" },
            { "GA", "Gabon" },
            { "GB", "Verenigd Koninkrijk" },
            { "GD", "Grenada" },
            { "GE", "Georgi\u00eb" },
            { "GF", "Frans-Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenland" },
            { "GM", "Gambia" },
            { "GN", "Guinee" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatoriaal-Guinea" },
            { "GR", "Griekenland" },
            { "GS", "Zuid-Georgi\u00eb en Zuidelijke Sandwicheilanden" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinee-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hongkong SAR van China" },
            { "HM", "Heard- en McDonaldeilanden" },
            { "HN", "Honduras" },
            { "HR", "Kroati\u00eb" },
            { "HT", "Ha\u00efti" },
            { "HU", "Hongarije" },
            { "IC", "Canarische Eilanden" },
            { "ID", "Indonesi\u00eb" },
            { "IE", "Ierland" },
            { "IL", "Isra\u00ebl" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "Britse Gebieden in de Indische Oceaan" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "IJsland" },
            { "IT", "Itali\u00eb" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordani\u00eb" },
            { "JP", "Japan" },
            { "KE", "Kenia" },
            { "KG", "Kirgizi\u00eb" },
            { "KH", "Cambodja" },
            { "KI", "Kiribati" },
            { "KM", "Comoren" },
            { "KN", "Saint Kitts en Nevis" },
            { "KP", "Noord-Korea" },
            { "KR", "Zuid-Korea" },
            { "KW", "Koeweit" },
            { "KY", "Caymaneilanden" },
            { "KZ", "Kazachstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Litouwen" },
            { "LU", "Luxemburg" },
            { "LV", "Letland" },
            { "LY", "Libi\u00eb" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldavi\u00eb" },
            { "ME", "Montenegro" },
            { "MF", "Sint-Maarten" },
            { "MG", "Madagaskar" },
            { "MH", "Marshalleilanden" },
            { "MK", "Macedoni\u00eb" },
            { "ML", "Mali" },
            { "MM", "Myanmar" },
            { "MN", "Mongoli\u00eb" },
            { "MO", "Macao SAR van China" },
            { "MP", "Noordelijke Marianeneilanden" },
            { "MQ", "Martinique" },
            { "MR", "Mauritani\u00eb" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldiven" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Maleisi\u00eb" },
            { "MZ", "Mozambique" },
            { "NA", "Namibi\u00eb" },
            { "NC", "Nieuw-Caledoni\u00eb" },
            { "NE", "Niger" },
            { "NF", "Norfolkeiland" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Nederland" },
            { "NO", "Noorwegen" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nieuw-Zeeland" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Frans-Polynesi\u00eb" },
            { "PG", "Papoea-Nieuw-Guinea" },
            { "PH", "Filipijnen" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "PM", "Saint Pierre en Miquelon" },
            { "PN", "Pitcairneilanden" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestijnse gebieden" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Overig Oceani\u00eb" },
            { "RE", "R\u00e9union" },
            { "RO", "Roemeni\u00eb" },
            { "RS", "Servi\u00eb" },
            { "RU", "Rusland" },
            { "RW", "Rwanda" },
            { "SA", "Saoedi-Arabi\u00eb" },
            { "SB", "Salomonseilanden" },
            { "SC", "Seychellen" },
            { "SD", "Soedan" },
            { "SE", "Zweden" },
            { "SG", "Singapore" },
            { "SH", "Sint-Helena" },
            { "SI", "Sloveni\u00eb" },
            { "SJ", "Svalbard en Jan Mayen" },
            { "SK", "Slowakije" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somali\u00eb" },
            { "SR", "Suriname" },
            { "ST", "Sao Tom\u00e9 en Principe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syri\u00eb" },
            { "SZ", "Swaziland" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- en Caicoseilanden" },
            { "TD", "Tsjaad" },
            { "TF", "Franse Gebieden in de zuidelijke Indische Oceaan" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadzjikistan" },
            { "TK", "Tokelau" },
            { "TL", "Oost-Timor" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunesi\u00eb" },
            { "TO", "Tonga" },
            { "TR", "Turkije" },
            { "TT", "Trinidad en Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Oekra\u00efne" },
            { "UG", "Oeganda" },
            { "UM", "Kleine afgelegen eilanden van de Verenigde Staten" },
            { "US", "Verenigde Staten" },
            { "UY", "Uruguay" },
            { "UZ", "Oezbekistan" },
            { "VA", "Vaticaanstad" },
            { "VC", "Saint Vincent en de Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Britse Maagdeneilanden" },
            { "VI", "Amerikaanse Maagdeneilanden" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis en Futuna" },
            { "WS", "Samoa" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Zuid-Afrika" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Onbekend of onjuist gebied" },
            { "aa", "Afar" },
            { "ab", "Abchazisch" },
            { "ae", "Avestisch" },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Amhaars" },
            { "an", "Aragonees" },
            { "ar", "Arabisch" },
            { "as", "Assamees" },
            { "av", "Avarisch" },
            { "ay", "Aymara" },
            { "az", "Azerbeidzjaans" },
            { "ba", "Basjkiers" },
            { "be", "Wit-Russisch" },
            { "bg", "Bulgaars" },
            { "bh", "Bihari" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", "Bengalees" },
            { "bo", "Tibetaans" },
            { "br", "Bretons" },
            { "bs", "Bosnisch" },
            { "ca", "Catalaans" },
            { "ce", "Tsjetsjeens" },
            { "ch", "Chamorro" },
            { "co", "Corsicaans" },
            { "cr", "Cree" },
            { "cs", "Tsjechisch" },
            { "cu", "Kerkslavisch" },
            { "cv", "Tsjoevasjisch" },
            { "cy", "Welsh" },
            { "da", "Deens" },
            { "de", "Duits" },
            { "dv", "Divehi" },
            { "dz", "Dzongkha" },
            { "ee", "Ewe" },
            { "el", "Grieks" },
            { "en", "Engels" },
            { "eo", "Esperanto" },
            { "es", "Spaans" },
            { "et", "Estlands" },
            { "eu", "Baskisch" },
            { "fa", "Perzisch" },
            { "ff", "Fulah" },
            { "fi", "Fins" },
            { "fj", "Fijisch" },
            { "fo", "Faer\u00f6ers" },
            { "fr", "Frans" },
            { "fy", "West-Fries" },
            { "ga", "Iers" },
            { "gd", "Schots Gaelic" },
            { "gl", "Galicisch" },
            { "gn", "Guarani" },
            { "gu", "Gujarati" },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", "Hebreeuws" },
            { "hi", "Hindi" },
            { "ho", "Hiri Motu" },
            { "hr", "Kroatisch" },
            { "ht", "Ha\u00eftiaans" },
            { "hu", "Hongaars" },
            { "hy", "Armeens" },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", "Indonesisch" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "ik", "Inupiaq" },
            { "io", "Ido" },
            { "is", "IJslands" },
            { "it", "Italiaans" },
            { "iu", "Inuktitut" },
            { "ja", "Japans" },
            { "jv", "Javaans" },
            { "ka", "Georgisch" },
            { "kg", "Kongo" },
            { "ki", "Kikuyu" },
            { "kj", "Kuanyama" },
            { "kk", "Kazachs" },
            { "kl", "Groenlands" },
            { "km", "Khmer" },
            { "kn", "Kannada" },
            { "ko", "Koreaans" },
            { "kr", "Kanuri" },
            { "ks", "Kasjmiri" },
            { "ku", "Koerdisch" },
            { "kv", "Komi" },
            { "kw", "Cornish" },
            { "ky", "Kirgizisch" },
            { "la", "Latijn" },
            { "lb", "Luxemburgs" },
            { "lg", "Ganda" },
            { "li", "Limburgs" },
            { "ln", "Lingala" },
            { "lo", "Laotiaans" },
            { "lt", "Litouws" },
            { "lu", "Luba-Katanga" },
            { "lv", "Letlands" },
            { "mg", "Malagasisch" },
            { "mh", "Marshallees" },
            { "mi", "Maori" },
            { "mk", "Macedonisch" },
            { "ml", "Malayalam" },
            { "mn", "Mongools" },
            { "mo", "Moldavisch" },
            { "mr", "Marathi" },
            { "ms", "Maleis" },
            { "mt", "Maltees" },
            { "my", "Birmees" },
            { "na", "Nauruaans" },
            { "nb", "Noors - Bokm\u00e5l" },
            { "nd", "Noord-Ndbele" },
            { "ne", "Nepalees" },
            { "ng", "Ndonga" },
            { "nl", "Nederlands" },
            { "nn", "Noors - Nynorsk" },
            { "no", "Noors" },
            { "nr", "Zuid-Ndbele" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "oc", "Occitaans" },
            { "oj", "Ojibwa" },
            { "om", "Oromo" },
            { "or", "Oriya" },
            { "os", "Ossetisch" },
            { "pa", "Punjabi" },
            { "pi", "Pali" },
            { "pl", "Pools" },
            { "ps", "Pasjtoe" },
            { "pt", "Portugees" },
            { "qu", "Quechua" },
            { "rm", "Reto-Romaans" },
            { "rn", "Kirundi" },
            { "ro", "Roemeens" },
            { "ru", "Russisch" },
            { "rw", "Kinyarwanda" },
            { "sa", "Sanskriet" },
            { "sc", "Sardinisch" },
            { "sd", "Sindhi" },
            { "se", "Noord-Samisch" },
            { "sg", "Sango" },
            { "sh", "Servokroatisch" },
            { "si", "Singalees" },
            { "sk", "Slowaaks" },
            { "sl", "Sloveens" },
            { "sm", "Samoaans" },
            { "sn", "Shona" },
            { "so", "Somalisch" },
            { "sq", "Albanees" },
            { "sr", "Servisch" },
            { "ss", "Swazi" },
            { "st", "Zuid-Sotho" },
            { "su", "Soendanees" },
            { "sv", "Zweeds" },
            { "sw", "Swahili" },
            { "ta", "Tamil" },
            { "te", "Teloegoe" },
            { "tg", "Tadzjieks" },
            { "th", "Thais" },
            { "ti", "Tigrinya" },
            { "tk", "Turkmeens" },
            { "tl", "Tagalog" },
            { "tn", "Tswana" },
            { "to", "Tongaans" },
            { "tr", "Turks" },
            { "ts", "Tsonga" },
            { "tt", "Tataars" },
            { "tw", "Twi" },
            { "ty", "Tahitisch" },
            { "ug", "Oeigoers" },
            { "uk", "Oekra\u00efens" },
            { "ur", "Urdu" },
            { "uz", "Oezbeeks" },
            { "ve", "Venda" },
            { "vi", "Vietnamees" },
            { "vo", "Volap\u00fck" },
            { "wa", "Waals" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Jiddisch" },
            { "yo", "Yoruba" },
            { "za", "Zhuang" },
            { "zh", "Chinees" },
            { "zu", "Zulu" },
            { "ace", "Atjees" },
            { "ach", "Akoli" },
            { "ada", "Adangme" },
            { "ady", "Adyghe" },
            { "afa", "Afro-Aziatische taal" },
            { "afh", "Afrihili" },
            { "ain", "Ainu" },
            { "akk", "Akkadisch" },
            { "ale", "Aleut" },
            { "alg", "Algonkium-taal" },
            { "alt", "Zuid-Alta\u00efsch" },
            { "ang", "Oudengels" },
            { "anp", "Angika" },
            { "apa", "Apache-taal" },
            { "arc", "Aramees" },
            { "arn", "Araukaans" },
            { "arp", "Arapaho" },
            { "art", "Kunstmatige taal" },
            { "arw", "Arawak" },
            { "ast", "Asturisch" },
            { "ath", "Athapascaanse taal" },
            { "aus", "Australische taal" },
            { "awa", "Awadhi" },
            { "bad", "Banda" },
            { "bai", "Bamileke-taal" },
            { "bal", "Baloetsji" },
            { "ban", "Balinees" },
            { "bas", "Basa" },
            { "bat", "Baltische taal" },
            { "bej", "Beja" },
            { "bem", "Bemba" },
            { "ber", "Berber" },
            { "bho", "Bhojpuri" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "bla", "Siksika" },
            { "bnt", "Bantoe" },
            { "bra", "Braj" },
            { "btk", "Batak" },
            { "bua", "Buriat" },
            { "bug", "Buginees" },
            { "byn", "Blin" },
            { "cad", "Caddo" },
            { "cai", "Midden-Amerikaans Indiaanse taal" },
            { "car", "Caribisch" },
            { "cau", "Kaukasische taal" },
            { "cch", "Atsam" },
            { "ceb", "Cebuano" },
            { "cel", "Keltische taal" },
            { "chb", "Chibcha" },
            { "chg", "Chagatai" },
            { "chk", "Chuukees" },
            { "chm", "Mari" },
            { "chn", "Chinook-jargon" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", "Cherokee" },
            { "chy", "Cheyenne" },
            { "cmc", "Chamische taal" },
            { "cop", "Koptisch" },
            { "cpe", "Op Engels gebaseerd Creools of Pidgin" },
            { "cpf", "Op Frans gebaseerd Creools of Pidgin" },
            { "cpp", "Op Portugees gebaseerd Creools of Pidgin" },
            { "crh", "Krim-Tataars" },
            { "crp", "Creools of Pidgin" },
            { "csb", "Kasjoebisch" },
            { "cus", "Koesjitische taal" },
            { "dak", "Dakota" },
            { "dar", "Dargwa" },
            { "day", "Dajak" },
            { "del", "Delaware" },
            { "den", "Slave" },
            { "dgr", "Dogrib" },
            { "din", "Dinka" },
            { "doi", "Dogri" },
            { "dra", "Dravidische taal" },
            { "dsb", "Nedersorbisch" },
            { "dua", "Duala" },
            { "dum", "Middelnederlands" },
            { "dyu", "Dyula" },
            { "efi", "Efik" },
            { "egy", "Oudegyptisch" },
            { "eka", "Ekajuk" },
            { "elx", "Elamitisch" },
            { "enm", "Middelengels" },
            { "ewo", "Ewondo" },
            { "fan", "Fang" },
            { "fat", "Fanti" },
            { "fil", "Filippijns" },
            { "fiu", "Fins-Oegrische taal" },
            { "fon", "Fon" },
            { "frm", "Middelfrans" },
            { "fro", "Oudfrans" },
            { "frr", "Noord-Fries" },
            { "frs", "Oost-Fries" },
            { "fur", "Friulisch" },
            { "gaa", "Ga" },
            { "gay", "Gayo" },
            { "gba", "Gbaya" },
            { "gem", "Germaanse taal" },
            { "gez", "Geez" },
            { "gil", "Gilbertees" },
            { "gmh", "Middelhoogduits" },
            { "goh", "Oudhoogduits" },
            { "gon", "Gondi" },
            { "gor", "Gorontalo" },
            { "got", "Gothisch" },
            { "grb", "Grebo" },
            { "grc", "Oudgrieks" },
            { "gsw", "Zwitsers Duits" },
            { "gwi", "Gwich\u02bcin" },
            { "hai", "Haida" },
            { "haw", "Hawa\u00efaans" },
            { "hil", "Hiligaynon" },
            { "him", "Himachali" },
            { "hit", "Hettitisch" },
            { "hmn", "Hmong" },
            { "hsb", "Oppersorbisch" },
            { "hup", "Hupa" },
            { "iba", "Iban" },
            { "ijo", "Ijo" },
            { "ilo", "Iloko" },
            { "inc", "Indische taal" },
            { "ine", "Indo-Europese taal" },
            { "inh", "Ingoesj" },
            { "ira", "Iraanse taal" },
            { "iro", "Irokese taal" },
            { "jbo", "Lojban" },
            { "jpr", "Judeo-Perzisch" },
            { "jrb", "Judeo-Arabisch" },
            { "kaa", "Karakalpaks" },
            { "kab", "Kabyle" },
            { "kac", "Kachin" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kar", "Karen" },
            { "kaw", "Kawi" },
            { "kbd", "Kabardisch" },
            { "kcg", "Tyap" },
            { "kea", "Kabuverdianu" },
            { "kfo", "Koro" },
            { "kha", "Khasi" },
            { "khi", "Khoisan-taal" },
            { "kho", "Khotanees" },
            { "kmb", "Kimbundu" },
            { "kok", "Konkani" },
            { "kos", "Kosraeaans" },
            { "kpe", "Kpelle" },
            { "krc", "Karachay-Balkar" },
            { "krl", "Karelisch" },
            { "kro", "Kru" },
            { "kru", "Kurukh" },
            { "kum", "Koemuks" },
            { "kut", "Kutenai" },
            { "lad", "Ladino" },
            { "lah", "Lahnda" },
            { "lam", "Lamba" },
            { "lez", "Lezgisch" },
            { "lol", "Mongo" },
            { "loz", "Lozi" },
            { "lua", "Luba-Lulua" },
            { "lui", "Luiseno" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "lus", "Lushai" },
            { "mad", "Madurees" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", "Makassaars" },
            { "man", "Mandingo" },
            { "map", "Austronesisch" },
            { "mas", "Masai" },
            { "mdf", "Moksha" },
            { "mdr", "Mandar" },
            { "men", "Mende" },
            { "mga", "Middeliers" },
            { "mic", "Mi'kmaq" },
            { "min", "Minangkabau" },
            { "mis", "Diverse talen" },
            { "mkh", "Mon-Khmer-taal" },
            { "mnc", "Mantsjoe" },
            { "mni", "Manipoeri" },
            { "mno", "Manobo-taal" },
            { "moh", "Mohawk" },
            { "mos", "Mossi" },
            { "mul", "Meerdere talen" },
            { "mun", "Munda-taal" },
            { "mus", "Creek" },
            { "mwl", "Mirandees" },
            { "mwr", "Marwari" },
            { "myn", "Mayan-taal" },
            { "myv", "Erzja" },
            { "nah", "Nahuatl" },
            { "nai", "Noord-Amerikaans Indiaanse taal" },
            { "nap", "Napolitaans" },
            { "nds", "Laagduits" },
            { "new", "Newari" },
            { "nia", "Nias" },
            { "nic", "Niger-Kordofanische taal" },
            { "niu", "Niueaans" },
            { "nog", "Nogai" },
            { "non", "Oudnoors" },
            { "nqo", "N\u2019ko" },
            { "nso", "Noord-Sotho" },
            { "nub", "Nubische taal" },
            { "nwc", "Klassiek Newari" },
            { "nym", "Nyamwezi" },
            { "nyn", "Nyankole" },
            { "nyo", "Nyoro" },
            { "nzi", "Nzima" },
            { "osa", "Osage" },
            { "ota", "Ottomaans-Turks" },
            { "oto", "Otomi-taal" },
            { "paa", "Papoeataal" },
            { "pag", "Pangasinan" },
            { "pal", "Pahlavi" },
            { "pam", "Pampanga" },
            { "pap", "Papiaments" },
            { "pau", "Palauaans" },
            { "peo", "Oudperzisch" },
            { "phi", "Filippijnse taal" },
            { "phn", "Foenicisch" },
            { "pon", "Pohnpeiaans" },
            { "pra", "Prakrit-taal" },
            { "pro", "Oudproven\u00e7aals" },
            { "raj", "Rajasthani" },
            { "rap", "Rapanui" },
            { "rar", "Rarotongan" },
            { "roa", "Romaanse taal" },
            { "rom", "Romani" },
            { "rup", "Aromaniaans" },
            { "sad", "Sandawe" },
            { "sah", "Jakoets" },
            { "sai", "Zuid-Amerikaans Indiaanse taal" },
            { "sal", "Salishan-taal" },
            { "sam", "Samaritaans-Aramees" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "scn", "Siciliaans" },
            { "sco", "Schots" },
            { "sel", "Selkup" },
            { "sem", "Semitische taal" },
            { "sga", "Oudiers" },
            { "sgn", "Gebarentaal" },
            { "shn", "Shan" },
            { "sid", "Sidamo" },
            { "sio", "Siouaanse talen" },
            { "sit", "Sino-Tibetaanse taal" },
            { "sla", "Slavische taal" },
            { "sma", "Zuid-Samisch" },
            { "smi", "Sami-taal" },
            { "smj", "Lule Sami" },
            { "smn", "Inari Sami" },
            { "sms", "Skolt Sami" },
            { "snk", "Soninke" },
            { "sog", "Sogdisch" },
            { "son", "Songhai" },
            { "srn", "Sranantongo" },
            { "srr", "Serer" },
            { "ssa", "Nilo-Saharaanse taal" },
            { "suk", "Sukuma" },
            { "sus", "Soesoe" },
            { "sux", "Soemerisch" },
            { "swb", "Shimaore" },
            { "syc", "Klassiek Syrisch" },
            { "syr", "Syriac" },
            { "tai", "Tai-taal" },
            { "tem", "Timne" },
            { "ter", "Tereno" },
            { "tet", "Tetun" },
            { "tig", "Tigre" },
            { "tiv", "Tiv" },
            { "tkl", "Tokelaus" },
            { "tlh", "Klingon" },
            { "tli", "Tlingit" },
            { "tmh", "Tamashek" },
            { "tog", "Nyasa Tonga" },
            { "tpi", "Tok Pisin" },
            { "tsi", "Tsimshian" },
            { "tum", "Toemboeka" },
            { "tup", "Tupi-taal" },
            { "tut", "Alta\u00efsche taal" },
            { "tvl", "Tuvaluaans" },
            { "tyv", "Tuvinisch" },
            { "udm", "Oedmoerts" },
            { "uga", "Oegaritisch" },
            { "umb", "Umbundu" },
            { "und", "Onbekende taal" },
            { "vai", "Vai" },
            { "vot", "Votisch" },
            { "wak", "Wakashan-taal" },
            { "wal", "Walamo" },
            { "war", "Waray" },
            { "was", "Washo" },
            { "wen", "Sorbische taal" },
            { "xal", "Kalmyk" },
            { "yao", "Yao" },
            { "yap", "Yapees" },
            { "ypk", "Yupik-talen" },
            { "yue", "Kantonees" },
            { "zap", "Zapotec" },
            { "zbl", "Blissymbolen" },
            { "zen", "Zenaga" },
            { "znd", "Zande" },
            { "zun", "Zuni" },
            { "zxx", "Geen lingu\u00efstische inhoud" },
            { "zza", "Zaza" },
            { "Arab", "Arabisch" },
            { "Armi", "Keizerlijk Aramees" },
            { "Armn", "Armeens" },
            { "Avst", "Avestaans" },
            { "Bali", "Balinees" },
            { "Batk", "Batak" },
            { "Beng", "Bengalees" },
            { "Blis", "Blissymbolen" },
            { "Bopo", "Bopomofo" },
            { "Brah", "Brahmi" },
            { "Brai", "Braille" },
            { "Bugi", "Buginees" },
            { "Buhd", "Buhid" },
            { "Cakm", "Chakma" },
            { "Cans", "Verenigde Canadese Aboriginal-symbolen" },
            { "Cari", "Carisch" },
            { "Cham", "Cham" },
            { "Cher", "Cherokee" },
            { "Cirt", "Cirth" },
            { "Copt", "Koptisch" },
            { "Cprt", "Cyprisch" },
            { "Cyrl", "Cyrillisch" },
            { "Cyrs", "Oudkerkslavisch Cyrillisch" },
            { "Deva", "Devanagari" },
            { "Dsrt", "Deseret" },
            { "Egyd", "Egyptisch demotisch" },
            { "Egyh", "Egyptisch hi\u00ebratisch" },
            { "Egyp", "Egyptische hi\u00ebrogliefen" },
            { "Ethi", "Ethiopisch" },
            { "Geok", "Georgisch Khutsuri" },
            { "Geor", "Georgisch" },
            { "Glag", "Glagolitisch" },
            { "Goth", "Gothisch" },
            { "Grek", "Grieks" },
            { "Gujr", "Gujarati" },
            { "Guru", "Gurmukhi" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hano", "Hanunoo" },
            { "Hans", "Vereenvoudigd Han" },
            { "Hant", "Traditioneel Han" },
            { "Hebr", "Hebreeuws" },
            { "Hira", "Hiragana" },
            { "Hmng", "Pahawh Hmong" },
            { "Hrkt", "Katakana of Hiragana" },
            { "Hung", "Oudhongaars" },
            { "Inds", "Indus" },
            { "Ital", "Oud-italisch" },
            { "Java", "Javaans" },
            { "Jpan", "Japans" },
            { "Kali", "Kayah Li" },
            { "Kana", "Katakana" },
            { "Khar", "Kharoshthi" },
            { "Khmr", "Khmer" },
            { "Knda", "Kannada" },
            { "Kore", "Koreaans" },
            { "Kthi", "Kaithi" },
            { "Lana", "Lanna" },
            { "Laoo", "Lao" },
            { "Latf", "Gotisch Latijn" },
            { "Latg", "Gaelisch Latijn" },
            { "Latn", "Latijn" },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Lineair A" },
            { "Linb", "Lineair B" },
            { "Lyci", "Lycisch" },
            { "Lydi", "Lydisch" },
            { "Mand", "Mandaeans" },
            { "Mani", "Manicheaans" },
            { "Maya", "Mayahi\u00ebrogliefen" },
            { "Mero", "Mero\u00eftisch" },
            { "Mlym", "Malayalam" },
            { "Mong", "Mongools" },
            { "Moon", "Moon" },
            { "Mtei", "Meitei" },
            { "Mymr", "Myanmar" },
            { "Nkoo", "N\u2019Ko" },
            { "Ogam", "Ogham" },
            { "Olck", "Ol Chiki" },
            { "Orkh", "Orkhon" },
            { "Orya", "Oriya" },
            { "Osma", "Osmanya" },
            { "Perm", "Oudpermisch" },
            { "Phag", "Phags-pa" },
            { "Phli", "Inscriptioneel Pahlavi" },
            { "Phlp", "Psalmen Pahlavi" },
            { "Phlv", "Boek Pahlavi" },
            { "Phnx", "Foenicisch" },
            { "Plrd", "Pollard-fonetisch" },
            { "Prti", "Inscriptioneel Parthisch" },
            { "Rjng", "Rejang" },
            { "Roro", "Rongorongo" },
            { "Runr", "Runic" },
            { "Samr", "Samaritaans" },
            { "Sara", "Sarati" },
            { "Saur", "Saurashtra" },
            { "Sgnw", "SignWriting" },
            { "Shaw", "Shavian" },
            { "Sinh", "Sinhala" },
            { "Sund", "Soendanees" },
            { "Sylo", "Syloti Nagri" },
            { "Syrc", "Syriac" },
            { "Syre", "Estrangelo Aramees" },
            { "Syrj", "West-Aramees" },
            { "Syrn", "Oost-Aramees" },
            { "Tagb", "Tagbanwa" },
            { "Tale", "Tai Le" },
            { "Talu", "Nieuw Tai Lue" },
            { "Taml", "Tamil" },
            { "Tavt", "Tai Viet" },
            { "Telu", "Telugu" },
            { "Teng", "Tengwar" },
            { "Tfng", "Tifinagh" },
            { "Tglg", "Tagalog" },
            { "Thaa", "Thaana" },
            { "Thai", "Thais" },
            { "Tibt", "Tibetaans" },
            { "Ugar", "Ugaritisch" },
            { "Vaii", "Vai" },
            { "Visp", "Zichtbare spraak" },
            { "Xpeo", "Oudperzisch" },
            { "Xsux", "Sumero-Akkadian Cuneiform" },
            { "Yiii", "Yi" },
            { "Zinh", "Overge\u00ebrfd" },
            { "Zmth", "Wiskundige notatie" },
            { "Zsym", "Symbolen" },
            { "Zxxx", "Code voor ongeschreven talen" },
            { "Zyyy", "Algemeen" },
            { "Zzzz", "Code voor ongecodeerde schriftsystemen" },
            { "root", "Root" },
            { "de_AT", "Oostenrijks Duits" },
            { "de_CH", "Zwitsers Hoogduits" },
            { "en_AU", "Australisch Engels" },
            { "en_CA", "Canadees Engels" },
            { "en_GB", "Brits Engels" },
            { "en_US", "Amerikaans Engels" },
            { "es_ES", "Iberisch Spaans" },
            { "fr_CA", "Canadees Frans" },
            { "fr_CH", "Zwitsers Frans" },
            { "nl_BE", "Vlaams" },
            { "pt_BR", "Braziliaans Portugees" },
            { "pt_PT", "Iberisch Portugees" },
            { "es_419", "Latijns-Amerikaans Spaans" },
            { "zh_Hans", "Vereenvoudigd Chinees" },
            { "zh_Hant", "Traditioneel Chinees" },
        };
        return data;
    }
}
