/*
 * Copyright (c) 2012, 2014, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.mk;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_mk extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Cocos = new String[] {
               "\u0412\u0440\u0435\u043c\u0435 \u043d\u0430 \u041a\u043e\u043a\u043e\u0441 \u043e\u0441\u0442\u0440\u043e\u0432\u0438",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Africa_Central = new String[] {
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e-\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "\u041c\u043e\u0441\u043a\u0432\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "MST",
               "\u041c\u043e\u0441\u043a\u0432\u0430 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "MST",
               "\u041c\u043e\u0441\u043a\u0432\u0430 \u0432\u0440\u0435\u043c\u0435",
               "MT",
            };
        final String[] Vostok = new String[] {
               "\u0412\u043e\u0441\u0442\u043e\u043a \u0432\u0440\u0435\u043c\u0435",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Argentina = new String[] {
               "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "AST",
               "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "AST",
               "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u0432\u0440\u0435\u043c\u0435",
               "AT",
            };
        final String[] Europe_Central = new String[] {
               "\u0421\u0440\u0435\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CET",
               "\u0421\u0440\u0435\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "CEST",
               "\u0421\u0440\u0435\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "CET",
            };
        final String[] Paraguay = new String[] {
               "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0458\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "PST",
               "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0458\u0441\u043a\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "PST",
               "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0458\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "PT",
            };
        final String[] America_Eastern = new String[] {
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "EST",
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "EDT",
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "ET",
            };
        final String[] Venezuela = new String[] {
               "\u0412\u0435\u043d\u0435\u0446\u0443\u0435\u043b\u0430 \u0432\u0440\u0435\u043c\u0435",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Indian_Ocean = new String[] {
               "\u0412\u0440\u0435\u043c\u0435 \u043d\u0430 \u0418\u043d\u0434\u0438\u0441\u043a\u0438 \u041e\u043a\u0435\u0430\u043d",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] America_Pacific = new String[] {
               "\u041f\u0430\u0446\u0438\u0444\u0438\u0447\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "PST",
               "\u041f\u0430\u0446\u0438\u0444\u0438\u0447\u043a\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "PDT",
               "\u041f\u0430\u0446\u0438\u0444\u0438\u0447\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "PT",
            };
        final String[] Mauritius = new String[] {
               "\u0412\u0440\u0435\u043c\u0435 \u043d\u0430 \u041c\u0430\u0443\u0440\u0438\u0446\u0438\u0443\u0441",
               "MST",
               "\u041b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e \u043d\u0430 \u041c\u0430\u0443\u0440\u0438\u0446\u0438\u0443\u0441",
               "MST",
               "Mauritius Time",
               "MT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e-\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Europe_Western = new String[] {
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WET",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "WEST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "WET",
            };
        final String[] Guyana = new String[] {
               "\u0413\u0432\u0430\u0458\u0430\u043d\u0430 \u0432\u0440\u0435\u043c\u0435",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "EET",
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "EEST",
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "EET",
            };
        final String[] Rothera = new String[] {
               "\u0420\u043e\u0442\u0435\u0440\u0430 \u0432\u0440\u0435\u043c\u0435",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Newfoundland = new String[] {
               "\u040a\u0443\u0444\u0430\u0443\u043d\u0434\u043b\u0435\u043d\u0434 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "NST",
               "\u040a\u0443\u0444\u0430\u0443\u043d\u0434\u043b\u0435\u043d\u0434 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "NDT",
               "\u040a\u0443\u0444\u0430\u0443\u043d\u0434\u043b\u0435\u043d\u0434 \u0432\u0440\u0435\u043c\u0435",
               "NT",
            };
        final String[] Argentina_Western = new String[] {
               "\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WAST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "WAST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u0432\u0440\u0435\u043c\u0435",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "\u0410\u0442\u043b\u0430\u043d\u0442\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "AST",
               "\u0410\u0442\u043b\u0430\u043d\u0442\u0441\u043a\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "ADT",
               "\u0410\u0442\u043b\u0430\u043d\u0442\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "AT",
            };
        final String[] Mawson = new String[] {
               "\u041c\u043e\u0441\u043e\u043d \u0432\u0440\u0435\u043c\u0435",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Davis = new String[] {
               "\u0414\u0435\u0458\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "\u041a\u0443\u0431\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CST",
               "\u041a\u0443\u0431\u0430 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "CDT",
               "\u041a\u0443\u0431\u0430 \u0432\u0440\u0435\u043c\u0435",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e-\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WAST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e-\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "WAST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e-\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "WAT",
            };
        final String[] GMT = new String[] {
               "\u0421\u0440\u0435\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435 \u0441\u043f\u043e\u0440\u0435\u0434 \u0413\u0440\u0438\u043d\u0438\u0447",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Bolivia = new String[] {
               "\u0411\u043e\u043b\u0438\u0432\u0438\u0458\u0430 \u0432\u0440\u0435\u043c\u0435",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\u041f\u0458\u0435\u0440 \u0438 \u041c\u0438\u043a\u0435\u043b\u043e\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "PMST",
               "\u041f\u0458\u0435\u0440 \u0438 \u041c\u0438\u043a\u0435\u043b\u043e\u043d \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "PMDT",
               "\u041f\u0458\u0435\u0440 \u0438 \u041c\u0438\u043a\u0435\u043b\u043e\u043d \u0432\u0440\u0435\u043c\u0435",
               "PMT",
            };
        final String[] French_Southern = new String[] {
               "\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u043e \u0458\u0443\u0436\u043d\u043e \u0438 \u0430\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u0447\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] Volgograd = new String[] {
               "\u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "VST",
               "\u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "VST",
               "\u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434 \u0432\u0440\u0435\u043c\u0435",
               "VT",
            };
        final String[] DumontDUrville = new String[] {
               "\u0414\u0438\u043c\u043e\u043d-\u0434\u0443\u0440\u0432\u0438\u043b \u0432\u0440\u0435\u043c\u0435",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Maldives = new String[] {
               "\u0412\u0440\u0435\u043c\u0435 \u043d\u0430 \u041c\u0430\u043b\u0434\u0438\u0432\u0438",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Peru = new String[] {
               "\u041f\u0435\u0440\u0443 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "PST",
               "\u041f\u0435\u0440\u0443 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "PST",
               "\u041f\u0435\u0440\u0443 \u0432\u0440\u0435\u043c\u0435",
               "PT",
            };
        final String[] Greenland_Western = new String[] {
               "\u0417\u0430\u043f\u0430\u0434\u0435\u043d \u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WGST",
               "\u0417\u0430\u043f\u0430\u0434\u0435\u043d \u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "WGST",
               "\u0417\u0430\u043f\u0430\u0434\u0435\u043d \u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434 \u0432\u0440\u0435\u043c\u0435",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "\u0415\u043a\u0432\u0430\u0434\u043e\u0440 \u0432\u0440\u0435\u043c\u0435",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u0418\u0441\u0442\u043e\u0447\u0435\u043d \u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "EGST",
               "\u0418\u0441\u0442\u043e\u0447\u0435\u043d \u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "EGST",
               "\u0418\u0441\u0442\u043e\u0447\u0435\u043d \u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434 \u0432\u0440\u0435\u043c\u0435",
               "EGT",
            };
        final String[] Africa_Southern = new String[] {
               "\u0408\u0443\u0436\u043d\u043e-\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Seychelles = new String[] {
               "\u0412\u0440\u0435\u043c\u0435 \u043d\u0430 \u0421\u0435\u0458\u0448\u0435\u043b\u0438",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Uruguay = new String[] {
               "\u0423\u0440\u0443\u0433\u0432\u0430\u0458 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "UST",
               "\u0423\u0440\u0443\u0433\u0432\u0430\u0458 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "UST",
               "\u0423\u0440\u0443\u0433\u0432\u0430\u0458 \u0432\u0440\u0435\u043c\u0435",
               "UT",
            };
        final String[] America_Central = new String[] {
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CST",
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "CDT",
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CT",
            };
        final String[] French_Guiana = new String[] {
               "\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0430 \u0413\u0432\u0430\u0458\u0430\u043d\u0430 \u0432\u0440\u0435\u043c\u0435",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Colombia = new String[] {
               "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u0458\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CST",
               "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u0458\u0430 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "CST",
               "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u0458\u0430 \u0432\u0440\u0435\u043c\u0435",
               "CT",
            };
        final String[] Chile = new String[] {
               "\u0427\u0438\u043b\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CST",
               "\u0427\u0438\u043b\u0435 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "CST",
               "\u0427\u0438\u043b\u0435 \u0432\u0440\u0435\u043c\u0435",
               "CT",
            };
        final String[] America_Mountain = new String[] {
               "\u041f\u043b\u0430\u043d\u0438\u043d\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "MST",
               "\u041f\u043b\u0430\u043d\u0438\u043d\u0441\u043a\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "MDT",
               "\u041f\u043b\u0430\u043d\u0438\u043d\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "MT",
            };
        final String[] Noronha = new String[] {
               "\u0424\u0435\u0440\u043d\u0430\u043d\u0434\u043e \u0434\u0435 \u041d\u043e\u0440\u043e\u045a\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "FNST",
               "\u0424\u0435\u0440\u043d\u0430\u043d\u0434\u043e \u0434\u0435 \u041d\u043e\u0440\u043e\u045a\u0430 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "FNST",
               "\u0424\u0435\u0440\u043d\u0430\u043d\u0434\u043e \u0434\u0435 \u041d\u043e\u0440\u043e\u045a\u0430 \u0432\u0440\u0435\u043c\u0435",
               "FNT",
            };
        final String[] Brasilia = new String[] {
               "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u0458\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "BST",
               "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u0458\u0430 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "BST",
               "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u0458\u0430 \u0432\u0440\u0435\u043c\u0435",
               "BT",
            };
        final String[] Suriname = new String[] {
               "\u0421\u0443\u0440\u0438\u043d\u0430\u043c \u0432\u0440\u0435\u043c\u0435",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Christmas = new String[] {
               "\u0412\u0440\u0435\u043c\u0435 \u043d\u0430 \u0411\u043e\u0436\u0438\u045c\u043d\u0438\u043e\u0442 \u043e\u0441\u0442\u0440\u043e\u0432",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "\u0410\u043c\u0430\u0437\u043e\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "AST",
               "\u0410\u043c\u0430\u0437\u043e\u043d \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "AST",
               "\u0410\u043c\u0430\u0437\u043e\u043d \u0432\u0440\u0435\u043c\u0435",
               "AT",
            };
        final String[] Reunion = new String[] {
               "\u0412\u0440\u0435\u043c\u0435 \u043d\u0430 \u0420\u0438\u0458\u0443\u043d\u0438\u043e\u043d",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final Object[][] data = new Object[][] {
            { "America/Cuiaba", Amazon },
            { "Indian/Mahe", Seychelles },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Libreville", Africa_Western },
            { "America/Marigot", Atlantic },
            { "Africa/Maputo", Africa_Central },
            { "America/El_Salvador", America_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Guatemala", America_Central },
            { "Europe/London", GMT },
            { "America/Cayman", America_Eastern },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Europe/Warsaw", Europe_Central },
            { "America/Chicago", America_Central },
            { "America/Halifax", Atlantic },
            { "Europe/Jersey", GMT },
            { "Antarctica/Rothera", Rothera },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Atlantic/St_Helena", GMT },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Europe/Guernsey", GMT },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "Africa/Kigali", Africa_Central },
            { "America/Creston", America_Mountain },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Europe/Kaliningrad", GMT },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "CST6CDT", America_Central },
            { "Antarctica/Davis", Davis },
            { "Atlantic/Canary", Europe_Western },
            { "America/Manaus", Amazon },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "Africa/Freetown", GMT },
            { "Europe/Bucharest", Europe_Eastern },
            { "Europe/Malta", Europe_Central },
            { "America/Resolute", America_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Kampala", Africa_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Africa/Casablanca", Europe_Western },
            { "America/Glace_Bay", Atlantic },
            { "Africa/Lagos", Africa_Western },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Johns", Newfoundland },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Denver", America_Mountain },
            { "Africa/Bamako", GMT },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Havana", Cuba },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Mayotte", Africa_Eastern },
            { "America/Barbados", Atlantic },
            { "Europe/Volgograd", Volgograd },
            { "America/Louisville", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/Thule", Atlantic },
            { "America/Curacao", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "America/Argentina/La_Rioja", Argentina },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "America/Porto_Velho", Amazon },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Harare", Africa_Central },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Europe/Paris", Europe_Central },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "America/Yellowknife", America_Mountain },
            { "America/Indiana/Vevay", America_Eastern },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Africa/Ceuta", Europe_Central },
            { "America/Jujuy", Argentina },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "America/Metlakatla", America_Pacific },
            { "America/Pangnirtung", America_Eastern },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "America/Phoenix", America_Mountain },
            { "Africa/Nouakchott", GMT },
            { "Africa/Niamey", Africa_Western },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Whitehorse", America_Pacific },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "America/Montreal", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "America/Grenada", Atlantic },
            { "Atlantic/Faeroe", Europe_Western },
            { "Europe/Bratislava", Europe_Central },
            { "America/Argentina/Tucuman", Argentina },
            { "Europe/Copenhagen", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "America/New_York", America_Eastern },
            { "Europe/Vienna", Europe_Central },
            { "America/Merida", America_Central },
            { "America/Mazatlan", America_Mountain },
            { "Europe/Tirane", Europe_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Caracas", Venezuela },
            { "America/Dominica", Atlantic },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "Africa/Monrovia", GMT },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "EST5EDT", America_Eastern },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Africa/Accra", GMT },
            { "Asia/Amman", Europe_Eastern },
            { "America/Maceio", Brasilia },
            { "Europe/Dublin", GMT },
            { "America/Toronto", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "America/Los_Angeles", America_Pacific },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
