/*
 * Copyright (c) 2012, 2014, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.fr;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_fr extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "heure normale d\u2019Afrique centrale",
               "CAT",
               "heure avanc\u00e9e d\u2019Afrique centrale",
               "CAST",
               "heure d\u2019Afrique centrale",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "heure normale de Moscou",
               "MST",
               "heure avanc\u00e9e de Moscou",
               "MST",
               "heure de Moscou",
               "MT",
            };
        final String[] Japan = new String[] {
               "heure normale du Japon",
               "JST",
               "heure avanc\u00e9e du Japon",
               "JDT",
               "heure du Japon",
               "JT",
            };
        final String[] Hovd = new String[] {
               "heure normale de Hovd",
               "HST",
               "heure avanc\u00e9e de Hovd",
               "HST",
               "heure de Hovd",
               "HT",
            };
        final String[] Magadan = new String[] {
               "heure normale de Magadan",
               "MST",
               "heure avanc\u00e9e de Magadan",
               "MST",
               "heure de Magadan",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "heure normale Centre Ouest australien",
               "ACWST",
               "heure avanc\u00e9e du Centre Ouest australien",
               "ACWDT",
               "heure Centre Ouest australien",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "heure normale de l\u2019Europe centrale",
               "CEST",
               "heure avanc\u00e9e d\u2019Europe centrale",
               "CEST",
               "heure de l\u2019Europe centrale",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "heure normale de Sakhalin",
               "SST",
               "heure avanc\u00e9e de Sakhalin",
               "SST",
               "heure de Sakhalin",
               "ST",
            };
        final String[] America_Eastern = new String[] {
               "heure normale de l\u2019Est",
               "EST",
               "heure avanc\u00e9e de l\u2019Est",
               "EDT",
               "heure de l\u2019Est",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "heure normale de Lord Howe",
               "LHST",
               "heure avanc\u00e9e de Lord Howe",
               "LHDT",
               "heure de Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "heure normale de Nouvelle-Z\u00e9lande",
               "NZST",
               "heure avanc\u00e9e de Nouvelle-Z\u00e9lande",
               "NZDT",
               "heure de Nouvelle-Z\u00e9lande",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "heure du Territoire britannique de l\u2019oc\u00e9an Indien",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "heure normale de Iakutsk",
               "YST",
               "heure avanc\u00e9e de Iakutsk",
               "YST",
               "heure de Iakutsk",
               "YT",
            };
        final String[] Mauritius = new String[] {
               "heure normale de Maurice",
               "MST",
               "heure avanc\u00e9e de Maurice",
               "MST",
               "heure de Maurice",
               "MT",
            };
        final String[] Africa_Eastern = new String[] {
               "heure normale d\u2019Afrique de l\u2019Est",
               "EAT",
               "heure avanc\u00e9e d\u2019Afrique de l\u2019Est",
               "EAST",
               "heure d\u2019Afrique de l\u2019Est",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "heure du Timor oriental",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Solomon = new String[] {
               "heure des \u00eeles Salomon",
               "SIT",
               "Solomon Islands Summer Time",
               "SIST",
               "Solomon Islands Time",
               "SIT",
            };
        final String[] Kosrae = new String[] {
               "heure de Kosrae",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Marshall_Islands = new String[] {
               "heure des \u00eeles Marshall",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Europe_Eastern = new String[] {
               "heure normale de l\u2019Europe de l\u2019Est",
               "EEST",
               "heure avanc\u00e9e d\u2019Europe de l\u2019Est",
               "EEST",
               "heure d\u2019Europe de l\u2019Est",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "heure normale de Terre-Neuve",
               "NST",
               "heure avanc\u00e9e de Terre-Neuve",
               "NDT",
               "heure de Terre-Neuve",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "heure normale d\u2019Afghanistan",
               "AT",
               "heure avanc\u00e9e d\u2019Afghanistan",
               "AST",
               "heure d\u2019Afghanistan",
               "AT",
            };
        final String[] Hong_Kong = new String[] {
               "heure normale de Hong Kong",
               "HKST",
               "heure avanc\u00e9e de Hong Kong",
               "HKST",
               "heure de Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "heure normale de l\u2019Ouest argentin",
               "WAST",
               "heure avanc\u00e9e de l\u2019Ouest argentin",
               "WAST",
               "heure de l\u2019Ouest argentin",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "heure normale de l\u2019Atlantique",
               "AST",
               "heure avanc\u00e9e de l\u2019Atlantique",
               "ADT",
               "heure de l\u2019Atlantique",
               "AT",
            };
        final String[] Ponape = new String[] {
               "heure de Ponape",
               "PT",
               "Ponape Summer Time",
               "PST",
               "Ponape Time",
               "PT",
            };
        final String[] Bolivia = new String[] {
               "heure de Bolivie",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Indochina = new String[] {
               "heure d\u2019Indochine",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Yekaterinburg = new String[] {
               "heure normale de Ekaterinbourg",
               "YST",
               "heure avanc\u00e9e de Ekaterinbourg",
               "YST",
               "heure de Ekaterinbourg",
               "YT",
            };
        final String[] Maldives = new String[] {
               "heure des Maldives",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Tahiti = new String[] {
               "heure de Tahiti",
               "TT",
               "Tahiti Summer Time",
               "TST",
               "Tahiti Time",
               "TT",
            };
        final String[] Israel = new String[] {
               "heure normale d\u2019Isra\u00ebl",
               "IST",
               "heure avanc\u00e9e d\u2019Isra\u00ebl",
               "IDT",
               "heure d\u2019Isra\u00ebl",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "heure du Centre indon\u00e9sien",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Wallis = new String[] {
               "heure de Wallis-et-Futuna",
               "WFT",
               "Wallis and Futuna Summer Time",
               "WFST",
               "Wallis and Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "heure normale d\u2019Afrique m\u00e9ridionale",
               "SAST",
               "heure avanc\u00e9e d\u2019Afrique m\u00e9ridionale",
               "SADT",
               "heure d\u2019Afrique m\u00e9ridionale",
               "SAT",
            };
        final String[] Line_Islands = new String[] {
               "heure des \u00eeles de la Ligne",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Omsk = new String[] {
               "heure normale de Omsk",
               "OST",
               "heure avanc\u00e9e de Omsk",
               "OST",
               "heure de Omsk",
               "OT",
            };
        final String[] Seychelles = new String[] {
               "heure des Seychelles",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Mongolia = new String[] {
               "heure normale de Oulan-Bator",
               "UBST",
               "heure avanc\u00e9e de Oulan-Bator",
               "UBST",
               "heure de Oulan-Bator",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "heure normale du Centre",
               "CST",
               "heure avanc\u00e9e du Centre",
               "CDT",
               "heure du Centre",
               "CT",
            };
        final String[] Truk = new String[] {
               "heure de Truk",
               "CT",
               "Chuuk Summer Time",
               "CST",
               "Chuuk Time",
               "CT",
            };
        final String[] Niue = new String[] {
               "heure de Niou\u00e9",
               "NT",
               "Niue Summer Time",
               "NST",
               "Niue Time",
               "NT",
            };
        final String[] Wake = new String[] {
               "heure de l\u2019\u00eele Wake",
               "WIT",
               "Wake Island Summer Time",
               "WIST",
               "Wake Island Time",
               "WIT",
            };
        final String[] Falkland = new String[] {
               "heure normale des \u00eeles Malouines",
               "FIST",
               "heure avanc\u00e9e des \u00eeles Malouines",
               "FIST",
               "heure des \u00eeles Malouines",
               "FIT",
            };
        final String[] Vanuatu = new String[] {
               "heure normale de Vanuatu",
               "VST",
               "heure avanc\u00e9e de Vanuatu",
               "VST",
               "heure de Vanuatu",
               "VT",
            };
        final String[] Novosibirsk = new String[] {
               "heure normale de Novossibirsk",
               "NST",
               "heure avanc\u00e9e de Novossibirsk",
               "NST",
               "heure de Novossibirsk",
               "NT",
            };
        final String[] Azores = new String[] {
               "heure normale des A\u00e7ores",
               "AST",
               "heure avanc\u00e9e des A\u00e7ores",
               "AST",
               "heure des A\u00e7ores",
               "AT",
            };
        final String[] Bhutan = new String[] {
               "heure du Bhoutan",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Nauru = new String[] {
               "heure de Nauru",
               "NT",
               "Nauru Summer Time",
               "NST",
               "Nauru Time",
               "NT",
            };
        final String[] Krasnoyarsk = new String[] {
               "heure normale de Krasno\u00efarsk",
               "KST",
               "heure avanc\u00e9e de Krasno\u00efarsk",
               "KST",
               "heure de Krasno\u00efarsk",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "heure de l\u2019Ouest kazakh",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Christmas = new String[] {
               "heure de l\u2019\u00eele Christmas",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "heure normale de l\u2019Amazonie",
               "AST",
               "heure avanc\u00e9e de l\u2019Amazonie",
               "AST",
               "heure de l\u2019Amazonie",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "heure de l\u2019Est kazakh",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Fiji = new String[] {
               "heure normale des \u00eeles Fidji",
               "FST",
               "heure avanc\u00e9e des \u00eeles Fidji",
               "FST",
               "heure des \u00eeles Fidji",
               "FT",
            };
        final String[] Reunion = new String[] {
               "heure de la R\u00e9union",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Cocos = new String[] {
               "heure des \u00eeles Cocos",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Chatham = new String[] {
               "heure normale des \u00eeles Chatham",
               "CST",
               "heure avanc\u00e9e des \u00eeles Chatham",
               "CDT",
               "heure des \u00eeles Chatham",
               "CT",
            };
        final String[] Argentina = new String[] {
               "heure normale d\u2019Argentine",
               "AST",
               "heure avanc\u00e9e de l\u2019Argentine",
               "AST",
               "heure de l\u2019Argentine",
               "AT",
            };
        final String[] Gambier = new String[] {
               "heure des \u00eeles Gambier",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Tuvalu = new String[] {
               "heure des Tuvalu",
               "TT",
               "Tuvalu Summer Time",
               "TST",
               "Tuvalu Time",
               "TT",
            };
        final String[] Galapagos = new String[] {
               "heure des \u00eeles Gal\u00e1pagos",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] Macquarie = new String[] {
               "Macquarie Island Time",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "heure de Macquarie",
               "MIT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "heure normale d\u2019Hawaii - Al\u00e9outiennes",
               "HAST",
               "heure avanc\u00e9e d\u2019Hawaii - Al\u00e9outiennes",
               "HADT",
               "heure d\u2019Hawaii - Al\u00e9outiennes",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "heure normale du Centre australien",
               "ACST",
               "heure avanc\u00e9e du Centre australien",
               "ACDT",
               "heure du Centre australien",
               "CAT",
            };
        final String[] America_Pacific = new String[] {
               "heure normale du Pacifique",
               "PST",
               "heure avanc\u00e9e du Pacifique",
               "PDT",
               "heure du Pacifique",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "heure des \u00eeles Phoenix",
               "PIT",
               "Phoenix Islands Summer Time",
               "PIST",
               "Phoenix Islands Time",
               "PIT",
            };
        final String[] Europe_Western = new String[] {
               "heure normale d\u2019Europe de l\u2019Ouest",
               "WEST",
               "heure avanc\u00e9e d\u2019Europe de l\u2019Ouest",
               "WEST",
               "heure d\u2019Europe de l\u2019Ouest",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "heure normale du Cap-Vert",
               "CVST",
               "heure avanc\u00e9e du Cap-Vert",
               "CVST",
               "heure du Cap-Vert",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "heure de Norfolk",
               "NIT",
               "Norfolk Islands Summer Time",
               "NIST",
               "Norfolk Islands Time",
               "NIT",
            };
        final String[] Guyana = new String[] {
               "heure du Guyana",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Pitcairn = new String[] {
               "heure de Pitcairn",
               "PT",
               "Pitcairn Summer Time",
               "PST",
               "Pitcairn Time",
               "PT",
            };
        final String[] Samoa = new String[] {
               "heure de Samoa",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Palau = new String[] {
               "heure de Palaos",
               "PT",
               "Palau Summer Time",
               "PST",
               "Palau Time",
               "PT",
            };
        final String[] Azerbaijan = new String[] {
               "heure normale d\u2019Azerba\u00efdjan",
               "AST",
               "heure avanc\u00e9e d\u2019Azerba\u00efdjan",
               "AST",
               "heure d\u2019Azerba\u00efdjan",
               "AT",
            };
        final String[] Davis = new String[] {
               "heure de Davis",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "heure normale de Cuba",
               "CST",
               "heure avanc\u00e9e de Cuba",
               "CDT",
               "heure de Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "heure normale d\u2019Afrique de l\u2019Ouest",
               "WAST",
               "heure avanc\u00e9e d\u2019Afrique de l\u2019Ouest",
               "WAST",
               "heure d\u2019Afrique de l\u2019Ouest",
               "WAT",
            };
        final String[] GMT = new String[] {
               "heure moyenne de Greenwich",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] French_Southern = new String[] {
               "heure des Terres australes fran\u00e7aises",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] South_Georgia = new String[] {
               "heure de G\u00e9orgie du Sud",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] New_Caledonia = new String[] {
               "heure normale de Nouvelle-Cal\u00e9donie",
               "NCST",
               "heure avanc\u00e9e de Nouvelle-Cal\u00e9donie",
               "NCST",
               "heure de Nouvelle-Cal\u00e9donie",
               "NCT",
            };
        final String[] Volgograd = new String[] {
               "heure normale de Volgograd",
               "VST",
               "heure avanc\u00e9e de Volgograd",
               "VST",
               "heure de Volgograd",
               "VT",
            };
        final String[] Brunei = new String[] {
               "heure du Brun\u00e9i",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Iran = new String[] {
               "heure normale d\u2019Iran",
               "IST",
               "heure avanc\u00e9e d\u2019Iran",
               "IDT",
               "heure d\u2019Iran",
               "IT",
            };
        final String[] Easter = new String[] {
               "heure normale de l\u2019\u00eele de P\u00e2ques",
               "EIST",
               "heure avanc\u00e9e de l\u2019\u00eele de P\u00e2ques",
               "EIST",
               "heure de l\u2019\u00eele de P\u00e2ques",
               "EIT",
            };
        final String[] DumontDUrville = new String[] {
               "heure de Dumont-d\u2019Urville",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Tonga = new String[] {
               "heure normale de Tonga",
               "TST",
               "heure avanc\u00e9e de Tonga",
               "TST",
               "heure de Tonga",
               "TT",
            };
        final String[] Bangladesh = new String[] {
               "heure normale du Bangladesh",
               "BST",
               "heure avanc\u00e9e du Bangladesh",
               "BST",
               "heure du Bangladesh",
               "BT",
            };
        final String[] Greenland_Western = new String[] {
               "heure normale de l\u2019Ouest du Groenland",
               "WGST",
               "heure avanc\u00e9e de l\u2019Ouest du Groenland",
               "WGST",
               "heure de l\u2019Ouest du Groenland",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "heure normale d\u2019\u00c9quateur",
               "ET",
               "heure avanc\u00e9e d\u2019\u00c9quateur",
               "EST",
               "heure d\u2019\u00c9quateur",
               "ET",
            };
        final String[] Greenland_Eastern = new String[] {
               "heure normale de l\u2019Est du Groenland",
               "EGST",
               "heure avanc\u00e9e de l\u2019Est du Groenland",
               "EGST",
               "heure de l\u2019Est du Groenland",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "heure du Golfe",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "heure de l\u2019Est indon\u00e9sien",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Korea = new String[] {
               "heure normale de Cor\u00e9e",
               "KST",
               "heure avanc\u00e9e de Cor\u00e9e",
               "KDT",
               "heure de Cor\u00e9e",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "heure normale de l\u2019Ouest australien",
               "AWST",
               "heure avanc\u00e9e de l\u2019Ouest australien",
               "AWDT",
               "heure de l\u2019Ouest australien",
               "WAT",
            };
        final String[] Indonesia_Western = new String[] {
               "heure de l\u2019Ouest indon\u00e9sien",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Australia_Eastern = new String[] {
               "heure normale de l\u2019Est australien",
               "AEST",
               "heure avanc\u00e9e de l\u2019Est australien",
               "AEDT",
               "heure de l\u2019Est australien",
               "EAT",
            };
        final String[] French_Guiana = new String[] {
               "heure de Guyane fran\u00e7aise",
               "FGT",
               "heure avanc\u00e9e de Guyane fran\u00e7aise",
               "FGST",
               "heure de Guyane fran\u00e7aise",
               "FGT",
            };
        final String[] Colombia = new String[] {
               "heure normale de Colombie",
               "CST",
               "heure avanc\u00e9e de Colombie",
               "CST",
               "heure de Colombie",
               "CT",
            };
        final String[] Chile = new String[] {
               "heure normale du Chili",
               "CST",
               "heure avanc\u00e9e du Chili",
               "CST",
               "heure du Chili",
               "CT",
            };
        final String[] Gilbert_Islands = new String[] {
               "heure des \u00eeles Gilbert",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] America_Mountain = new String[] {
               "heure normale des Rocheuses",
               "MST",
               "heure avanc\u00e9e des Rocheuses",
               "MDT",
               "heure des Rocheuses",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "heure des \u00eeles Marquises",
               "MT",
               "Marquesas Summer Time",
               "MST",
               "Marquesas Time",
               "MT",
            };
        final String[] Arabian = new String[] {
               "heure normale de l\u2019Arabie",
               "AST",
               "heure avanc\u00e9e de l\u2019Arabie",
               "ADT",
               "heure de l\u2019Arabie",
               "AT",
            };
        final String[] Alaska = new String[] {
               "heure normale de l\u2019Alaska",
               "AKST",
               "heure avanc\u00e9e de l\u2019Alaska",
               "AKDT",
               "heure de l\u2019Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "heure normale de Vladivostok",
               "VST",
               "heure avanc\u00e9e de Vladivostok",
               "VST",
               "heure de Vladivostok",
               "VT",
            };
        final String[] Chamorro = new String[] {
               "heure des Chamorro",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Irkutsk = new String[] {
               "heure normale d\u2019Irkoutsk",
               "IST",
               "heure avanc\u00e9e d\u2019Irkoutsk",
               "IST",
               "heure d\u2019Irkoutsk",
               "IT",
            };
        final String[] Georgia = new String[] {
               "heure normale de G\u00e9orgie",
               "GST",
               "heure avanc\u00e9e de G\u00e9orgie",
               "GST",
               "heure de G\u00e9orgie",
               "GT",
            };
        final String[] Tokelau = new String[] {
               "heure de Tokelau",
               "TT",
               "Tokelau Summer Time",
               "TST",
               "Tokelau Time",
               "TT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "heure de Papouasie-Nouvelle-Guin\u00e9e",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Noronha = new String[] {
               "heure normale de Fernando de Noronha",
               "FNST",
               "heure avanc\u00e9e de Fernando de Noronha",
               "FNST",
               "heure de Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "heure normale de Choibalsan",
               "CST",
               "heure avanc\u00e9e de Choibalsan",
               "CST",
               "heure de Choibalsan",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "heure normale de Brasilia",
               "BST",
               "heure avanc\u00e9e de Brasilia",
               "BST",
               "heure de Brasilia",
               "BT",
            };
        final String[] China = new String[] {
               "heure normale de Chine",
               "CST",
               "heure avanc\u00e9e de Chine",
               "CDT",
               "heure de Chine",
               "CT",
            };
        final String[] Armenia = new String[] {
               "heure normale d\u2019Arm\u00e9nie",
               "AST",
               "heure avanc\u00e9e d\u2019Arm\u00e9nie",
               "AST",
               "heure d\u2019Arm\u00e9nie",
               "AT",
            };
        final String[] India = new String[] {
               "heure normale de l\u2019Inde",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "heure normale des \u00eeles Cook",
               "CIST",
               "heure avanc\u00e9e des \u00eeles Cook",
               "CIHST",
               "heure des \u00eeles Cook",
               "CIT",
            };
        final Object[][] data = new Object[][] {
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London", GMT },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "America/Chicago", America_Central },
            { "Asia/Kashgar", China },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", GMT },
            { "Africa/Windhoek", Africa_Western },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Johns", Newfoundland },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "America/Denver", America_Mountain },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Asia/Shanghai", China },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Europe/Paris", Europe_Central },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "Africa/Djibouti", Africa_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Indianapolis", America_Eastern },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", America_Mountain },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Samoa },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin", GMT },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "America/Sitka", Alaska },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Asia/Jerusalem", Israel },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "Africa/Casablanca", Europe_Western },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "America/Phoenix", America_Mountain },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Thimphu", Bhutan },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/New_York", America_Eastern },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Tokyo", Japan },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "America/Los_Angeles", America_Pacific },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
