/*
 * Copyright (c) 2012, 2014, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.fa;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_fa extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "\u0648\u0642\u062a \u0645\u0631\u06a9\u0632 \u0627\u0641\u0631\u06cc\u0642\u0627",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0645\u0633\u06a9\u0648",
               "MST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0645\u0633\u06a9\u0648",
               "MST",
               "\u0648\u0642\u062a \u0645\u0633\u06a9\u0648",
               "MT",
            };
        final String[] Japan = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0698\u0627\u067e\u0646",
               "JST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0698\u0627\u067e\u0646",
               "JDT",
               "\u0648\u0642\u062a \u0698\u0627\u067e\u0646",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u067e\u0627\u06a9\u0633\u062a\u0627\u0646",
               "PST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u067e\u0627\u06a9\u0633\u062a\u0627\u0646",
               "PST",
               "\u0648\u0642\u062a \u067e\u0627\u06a9\u0633\u062a\u0627\u0646",
               "PT",
            };
        final String[] Hovd = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u062e\u0648\u0648\u062f",
               "HST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u062e\u0648\u0648\u062f",
               "HST",
               "\u0648\u0642\u062a \u062e\u0648\u0648\u062f",
               "HT",
            };
        final String[] Magadan = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0645\u0627\u06af\u0627\u062f\u0627\u0646",
               "MST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0645\u0627\u06af\u0627\u062f\u0627\u0646",
               "MST",
               "\u0648\u0642\u062a \u0645\u0627\u06af\u0627\u062f\u0627\u0646",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0633\u0627\u0639\u062a \u0627\u0633\u062a\u0627\u0646\u062f\u0627\u0631\u062f \u0645\u0631\u06a9\u0632\u06cc \u063a\u0631\u0628 \u0627\u0633\u062a\u0631\u0627\u0644\u06cc\u0627",
               "ACWST",
               "\u0633\u0627\u0639\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0645\u0631\u06a9\u0632\u06cc \u063a\u0631\u0628 \u0627\u0633\u062a\u0631\u0627\u0644\u06cc\u0627",
               "ACWDT",
               "\u0633\u0627\u0639\u062a \u0645\u0631\u06a9\u0632\u06cc \u063a\u0631\u0628 \u0627\u0633\u062a\u0631\u0627\u0644\u06cc\u0627",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0645\u0631\u06a9\u0632 \u0627\u0631\u0648\u067e\u0627",
               "CEST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0645\u0631\u06a9\u0632 \u0627\u0631\u0648\u067e\u0627",
               "CEST",
               "\u0648\u0642\u062a \u0645\u0631\u06a9\u0632 \u0627\u0631\u0648\u067e\u0627",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0633\u0627\u062e\u0627\u0644\u06cc\u0646",
               "SST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0633\u0627\u062e\u0627\u0644\u06cc\u0646",
               "SST",
               "\u0648\u0642\u062a \u0633\u0627\u062e\u0627\u0644\u06cc\u0646",
               "ST",
            };
        final String[] Paraguay = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u067e\u0627\u0631\u0627\u06af\u0648\u0626\u0647",
               "PST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u067e\u0627\u0631\u0627\u06af\u0648\u0626\u0647",
               "PST",
               "\u0648\u0642\u062a \u067e\u0627\u0631\u0627\u06af\u0648\u0626\u0647",
               "PT",
            };
        final String[] Malaysia = new String[] {
               "\u0648\u0642\u062a \u0645\u0627\u0644\u0632\u06cc",
               "MT",
               "Malaysia Summer Time",
               "MST",
               "Malaysia Time",
               "MT",
            };
        final String[] America_Eastern = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0634\u0631\u0642 \u0627\u0645\u0631\u06cc\u06a9\u0627",
               "EST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0634\u0631\u0642 \u0627\u0645\u0631\u06cc\u06a9\u0627",
               "EDT",
               "\u0648\u0642\u062a \u0634\u0631\u0642 \u0627\u0645\u0631\u06cc\u06a9\u0627",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "\u0633\u0627\u0639\u062a \u0627\u0633\u062a\u0627\u0646\u062f\u0627\u0631\u062f \u0644\u0631\u062f\u0647\u0648",
               "LHST",
               "\u0633\u0627\u0639\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0644\u0631\u062f\u0647\u0648",
               "LHDT",
               "\u0633\u0627\u0639\u062a \u0644\u0631\u062f\u0647\u0648",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0632\u0644\u0627\u0646\u062f \u0646\u0648",
               "NZST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0632\u0644\u0627\u0646\u062f \u0646\u0648",
               "NZDT",
               "\u0648\u0642\u062a \u0632\u0644\u0627\u0646\u062f \u0646\u0648",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "\u0648\u0642\u062a \u0627\u0642\u06cc\u0627\u0646\u0648\u0633 \u0647\u0646\u062f",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u06cc\u0627\u06a9\u0648\u062a\u0633\u06a9",
               "YST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u06cc\u0627\u06a9\u0648\u062a\u0633\u06a9",
               "YST",
               "\u0648\u0642\u062a \u06cc\u0627\u06a9\u0648\u062a\u0633\u06a9",
               "YT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u0648\u0642\u062a \u0634\u0631\u0642 \u0627\u0641\u0631\u06cc\u0642\u0627",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "\u0648\u0642\u062a \u062a\u06cc\u0645\u0648\u0631 \u0634\u0631\u0642\u06cc",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Solomon = new String[] {
               "\u0648\u0642\u062a \u062c\u0632\u0627\u06cc\u0631 \u0633\u0644\u06cc\u0645\u0627\u0646",
               "SIT",
               "Solomon Islands Summer Time",
               "SIST",
               "Solomon Islands Time",
               "SIT",
            };
        final String[] Marshall_Islands = new String[] {
               "\u0648\u0642\u062a \u062c\u0632\u0627\u06cc\u0631 \u0645\u0627\u0631\u0634\u0627\u0644",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0634\u0631\u0642 \u0627\u0631\u0648\u067e\u0627",
               "EEST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0634\u0631\u0642 \u0627\u0631\u0648\u067e\u0627",
               "EEST",
               "\u0648\u0642\u062a \u0634\u0631\u0642 \u0627\u0631\u0648\u067e\u0627",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\u0633\u0627\u0639\u062a \u0627\u0633\u062a\u0627\u0646\u062f\u0627\u0631\u062f \u0646\u06cc\u0648\u0641\u0648\u0646\u062f\u0644\u0646\u062f",
               "NST",
               "\u0633\u0627\u0639\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0646\u06cc\u0648\u0641\u0648\u0646\u062f\u0644\u0646\u062f",
               "NDT",
               "\u0633\u0627\u0639\u062a \u0646\u06cc\u0648\u0641\u0648\u0646\u062f\u0644\u0646\u062f",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646",
               "AT",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646",
               "AST",
               "\u0648\u0642\u062a \u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646",
               "AT",
            };
        final String[] Hong_Kong = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0647\u0646\u06af\u200c\u06a9\u0646\u06af",
               "HKST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0647\u0646\u06af\u200c\u06a9\u0646\u06af",
               "HKST",
               "\u0648\u0642\u062a \u0647\u0646\u06af\u200c\u06a9\u0646\u06af",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u063a\u0631\u0628 \u0622\u0631\u0698\u0627\u0646\u062a\u06cc\u0646",
               "WAST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u063a\u0631\u0628 \u0622\u0631\u0698\u0627\u0646\u062a\u06cc\u0646",
               "WAST",
               "\u0648\u0642\u062a \u063a\u0631\u0628 \u0622\u0631\u0698\u0627\u0646\u062a\u06cc\u0646",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0622\u062a\u0644\u0627\u0646\u062a\u06cc\u06a9",
               "AST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0622\u062a\u0644\u0627\u0646\u062a\u06cc\u06a9",
               "ADT",
               "\u0648\u0642\u062a \u0622\u062a\u0644\u0627\u0646\u062a\u06cc\u06a9",
               "AT",
            };
        final String[] Bolivia = new String[] {
               "\u0648\u0642\u062a \u0628\u0648\u0644\u06cc\u0648\u06cc",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Indochina = new String[] {
               "\u0648\u0642\u062a \u0647\u0646\u062f\u0648\u0686\u06cc\u0646",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u06cc\u06a9\u0627\u062a\u0631\u06cc\u0646\u0628\u0648\u0631\u06af",
               "YST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u06cc\u06a9\u0627\u062a\u0631\u06cc\u0646\u0628\u0648\u0631\u06af",
               "YST",
               "\u0648\u0642\u062a \u06cc\u06a9\u0627\u062a\u0631\u06cc\u0646\u0628\u0648\u0631\u06af",
               "YT",
            };
        final String[] Maldives = new String[] {
               "\u0648\u0642\u062a \u0645\u0627\u0644\u062f\u06cc\u0648",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Tahiti = new String[] {
               "\u0648\u0642\u062a \u062a\u0627\u0647\u06cc\u062a\u06cc",
               "TT",
               "Tahiti Summer Time",
               "TST",
               "Tahiti Time",
               "TT",
            };
        final String[] Israel = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0627\u0633\u0631\u0627\u0626\u06cc\u0644",
               "IST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0627\u0633\u0631\u0627\u0626\u06cc\u0644",
               "IDT",
               "\u0648\u0642\u062a \u0627\u0633\u0631\u0627\u0626\u06cc\u0644",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u0648\u0642\u062a \u0645\u0631\u06a9\u0632 \u0627\u0646\u062f\u0648\u0646\u0632\u06cc",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Africa_Southern = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u062c\u0646\u0648\u0628 \u0627\u0641\u0631\u06cc\u0642\u0627",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Uzbekistan = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0627\u0632\u0628\u06a9\u0633\u062a\u0627\u0646",
               "UST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0627\u0632\u0628\u06a9\u0633\u062a\u0627\u0646",
               "UST",
               "\u0648\u0642\u062a \u0627\u0632\u0628\u06a9\u0633\u062a\u0627\u0646",
               "UT",
            };
        final String[] Omsk = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0627\u0648\u0645\u0633\u06a9",
               "OST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0627\u0648\u0645\u0633\u06a9",
               "OST",
               "\u0648\u0642\u062a \u0627\u0648\u0645\u0633\u06a9",
               "OT",
            };
        final String[] Seychelles = new String[] {
               "\u0648\u0642\u062a \u0633\u06cc\u0634\u0644",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Uruguay = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0627\u0631\u0648\u06af\u0648\u0626\u0647",
               "UST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0627\u0631\u0648\u06af\u0648\u0626\u0647",
               "UST",
               "\u0648\u0642\u062a \u0627\u0631\u0648\u06af\u0648\u0626\u0647",
               "UT",
            };
        final String[] Nepal = new String[] {
               "\u0648\u0642\u062a \u0646\u067e\u0627\u0644",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Mongolia = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0627\u0648\u0644\u0627\u0646\u200c\u0628\u0627\u062a\u0648\u0631",
               "UBST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0627\u0648\u0644\u0627\u0646\u200c\u0628\u0627\u062a\u0648\u0631",
               "UBST",
               "\u0648\u0642\u062a \u0627\u0648\u0644\u0627\u0646\u200c\u0628\u0627\u062a\u0648\u0631",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0645\u0631\u06a9\u0632 \u0627\u0645\u0631\u06cc\u06a9\u0627",
               "CST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0645\u0631\u06a9\u0632 \u0627\u0645\u0631\u06cc\u06a9\u0627",
               "CDT",
               "\u0648\u0642\u062a \u0645\u0631\u06a9\u0632 \u0627\u0645\u0631\u06cc\u06a9\u0627",
               "CT",
            };
        final String[] Wake = new String[] {
               "\u0648\u0642\u062a \u062c\u0632\u06cc\u0631\u0647\u0654 \u0648\u06cc\u06a9",
               "WIT",
               "Wake Island Summer Time",
               "WIST",
               "Wake Island Time",
               "WIT",
            };
        final String[] Falkland = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u062c\u0632\u0627\u06cc\u0631 \u0641\u0627\u0644\u06a9\u0644\u0646\u062f",
               "FIST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u062c\u0632\u0627\u06cc\u0631 \u0641\u0627\u0644\u06a9\u0644\u0646\u062f",
               "FIST",
               "\u0648\u0642\u062a \u062c\u0632\u0627\u06cc\u0631 \u0641\u0627\u0644\u06a9\u0644\u0646\u062f",
               "FIT",
            };
        final String[] Vanuatu = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0648\u0627\u0646\u0627\u062a\u0648",
               "VST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0648\u0627\u0646\u0627\u062a\u0648",
               "VST",
               "\u0648\u0642\u062a \u0648\u0627\u0646\u0627\u062a\u0648",
               "VT",
            };
        final String[] Novosibirsk = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0646\u0648\u0648\u0633\u06cc\u0628\u06cc\u0631\u0633\u06a9",
               "NST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0646\u0648\u0648\u0633\u06cc\u0628\u06cc\u0631\u0633\u06a9",
               "NST",
               "\u0648\u0642\u062a \u0646\u0648\u0648\u0633\u06cc\u0628\u06cc\u0631\u0633\u06a9",
               "NT",
            };
        final String[] Singapore = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0633\u0646\u06af\u0627\u067e\u0648\u0631",
               "SST",
               "Singapore Daylight Time",
               "SDT",
               "Singapore Time",
               "ST",
            };
        final String[] Bhutan = new String[] {
               "\u0648\u0642\u062a \u0628\u0648\u062a\u0627\u0646",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Suriname = new String[] {
               "\u0648\u0642\u062a \u0633\u0648\u0631\u06cc\u0646\u0627\u0645",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Nauru = new String[] {
               "\u0648\u0642\u062a \u0646\u0627\u0626\u0648\u0631\u0648",
               "NT",
               "Nauru Summer Time",
               "NST",
               "Nauru Time",
               "NT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u06a9\u0631\u0627\u0633\u0646\u0648\u06cc\u0627\u0631\u0633\u06a9",
               "KST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u06a9\u0631\u0627\u0633\u0646\u0648\u06cc\u0627\u0631\u0633\u06a9",
               "KST",
               "\u0648\u0642\u062a \u06a9\u0631\u0627\u0633\u0646\u0648\u06cc\u0627\u0631\u0633\u06a9",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u0648\u0642\u062a \u063a\u0631\u0628 \u0642\u0632\u0627\u0642\u0633\u062a\u0627\u0646",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Myanmar = new String[] {
               "\u0648\u0642\u062a \u0645\u06cc\u0627\u0646\u0645\u0627\u0631",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Christmas = new String[] {
               "\u0648\u0642\u062a \u062c\u0632\u06cc\u0631\u0647\u0654 \u06a9\u0631\u06cc\u0633\u0645\u0633",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0622\u0645\u0627\u0632\u0648\u0646",
               "AST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0622\u0645\u0627\u0632\u0648\u0646",
               "AST",
               "\u0648\u0642\u062a \u0622\u0645\u0627\u0632\u0648\u0646",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u0648\u0642\u062a \u0634\u0631\u0642 \u0642\u0632\u0627\u0642\u0633\u062a\u0627\u0646",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Fiji = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0641\u06cc\u062c\u06cc",
               "FST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0641\u06cc\u062c\u06cc",
               "FST",
               "\u0648\u0642\u062a \u0641\u06cc\u062c\u06cc",
               "FT",
            };
        final String[] Cocos = new String[] {
               "\u0648\u0642\u062a \u062c\u0632\u0627\u06cc\u0631 \u06a9\u0648\u06a9\u0648\u0633",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Argentina = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0622\u0631\u0698\u0627\u0646\u062a\u06cc\u0646",
               "AST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0622\u0631\u0698\u0627\u0646\u062a\u06cc\u0646",
               "AST",
               "\u0648\u0642\u062a \u0622\u0631\u0698\u0627\u0646\u062a\u06cc\u0646",
               "AT",
            };
        final String[] Tuvalu = new String[] {
               "\u0648\u0642\u062a \u062a\u0648\u0648\u0627\u0644\u0648",
               "TT",
               "Tuvalu Summer Time",
               "TST",
               "Tuvalu Time",
               "TT",
            };
        final String[] Galapagos = new String[] {
               "\u0648\u0642\u062a \u06af\u0627\u0644\u0627\u067e\u0627\u06af\u0648\u0633",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] Macquarie = new String[] {
               "Macquarie Island Time",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "\u0633\u0627\u0639\u062a \u0645\u0627\u06a9\u0648\u0627\u0631\u06cc",
               "MIT",
            };
        final String[] Venezuela = new String[] {
               "\u0648\u0642\u062a \u0648\u0646\u0632\u0648\u0626\u0644\u0627",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u0633\u0627\u0639\u062a \u0639\u0627\u062f\u06cc \u0647\u0627\u0648\u0627\u06cc\u06cc \u0622\u0644\u0648\u0634\u0646",
               "HAST",
               "\u0633\u0627\u0639\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0647\u0627\u0648\u0627\u06cc\u06cc \u0622\u0644\u0648\u0634\u0646",
               "HADT",
               "\u0633\u0627\u0639\u062a \u0647\u0627\u0648\u0627\u06cc\u06cc \u0622\u0644\u0648\u0634\u0646",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0645\u0631\u06a9\u0632 \u0627\u0633\u062a\u0631\u0627\u0644\u06cc\u0627",
               "ACST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0645\u0631\u06a9\u0632 \u0627\u0633\u062a\u0631\u0627\u0644\u06cc\u0627",
               "ACDT",
               "\u0648\u0642\u062a \u0645\u0631\u06a9\u0632 \u0627\u0633\u062a\u0631\u0627\u0644\u06cc\u0627",
               "CAT",
            };
        final String[] America_Pacific = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u063a\u0631\u0628 \u0627\u0645\u0631\u06cc\u06a9\u0627",
               "PST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u063a\u0631\u0628 \u0627\u0645\u0631\u06cc\u06a9\u0627",
               "PDT",
               "\u0648\u0642\u062a \u063a\u0631\u0628 \u0627\u0645\u0631\u06cc\u06a9\u0627",
               "PT",
            };
        final String[] Turkmenistan = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u062a\u0631\u06a9\u0645\u0646\u0633\u062a\u0627\u0646",
               "TST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u062a\u0631\u06a9\u0645\u0646\u0633\u062a\u0627\u0646",
               "TST",
               "\u0648\u0642\u062a \u062a\u0631\u06a9\u0645\u0646\u0633\u062a\u0627\u0646",
               "TT",
            };
        final String[] Europe_Western = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u063a\u0631\u0628 \u0627\u0631\u0648\u067e\u0627",
               "WEST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u063a\u0631\u0628 \u0627\u0631\u0648\u067e\u0627",
               "WEST",
               "\u0648\u0642\u062a \u063a\u0631\u0628 \u0627\u0631\u0648\u067e\u0627",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u06a9\u06cc\u067e\u200c\u0648\u0631\u062f",
               "CVST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u06a9\u06cc\u067e\u200c\u0648\u0631\u062f",
               "CVST",
               "\u0648\u0642\u062a \u06a9\u06cc\u067e\u200c\u0648\u0631\u062f",
               "CVT",
            };
        final String[] Guyana = new String[] {
               "\u0648\u0642\u062a \u06af\u0648\u06cc\u0627\u0646",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Samoa = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0633\u0627\u0645\u0648\u0627",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Palau = new String[] {
               "\u0648\u0642\u062a \u067e\u0627\u0644\u0627\u0626\u0648",
               "PT",
               "Palau Summer Time",
               "PST",
               "Palau Time",
               "PT",
            };
        final String[] Azerbaijan = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u062c\u0645\u0647\u0648\u0631\u06cc \u0622\u0630\u0631\u0628\u0627\u06cc\u062c\u0627\u0646",
               "AST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u062c\u0645\u0647\u0648\u0631\u06cc \u0622\u0630\u0631\u0628\u0627\u06cc\u062c\u0627\u0646",
               "AST",
               "\u0648\u0642\u062a \u062c\u0645\u0647\u0648\u0631\u06cc \u0622\u0630\u0631\u0628\u0627\u06cc\u062c\u0627\u0646",
               "AT",
            };
        final String[] Davis = new String[] {
               "\u0648\u0642\u062a \u062f\u06cc\u0648\u06cc\u0633",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u06a9\u0648\u0628\u0627",
               "CST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u06a9\u0648\u0628\u0627",
               "CDT",
               "\u0648\u0642\u062a \u06a9\u0648\u0628\u0627",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u063a\u0631\u0628 \u0627\u0641\u0631\u06cc\u0642\u0627",
               "WAST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u063a\u0631\u0628 \u0627\u0641\u0631\u06cc\u0642\u0627",
               "WAST",
               "\u0648\u0642\u062a \u063a\u0631\u0628 \u0627\u0641\u0631\u06cc\u0642\u0627",
               "WAT",
            };
        final String[] GMT = new String[] {
               "\u0648\u0642\u062a \u06af\u0631\u06cc\u0646\u0648\u06cc\u0686",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Philippines = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0641\u06cc\u0644\u06cc\u067e\u06cc\u0646",
               "PST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0641\u06cc\u0644\u06cc\u067e\u06cc\u0646",
               "PST",
               "\u0648\u0642\u062a \u0641\u06cc\u0644\u06cc\u067e\u06cc\u0646",
               "PT",
            };
        final String[] South_Georgia = new String[] {
               "\u0648\u0642\u062a \u062c\u0648\u0631\u062c\u06cc\u0627\u06cc \u062c\u0646\u0648\u0628\u06cc",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] Volgograd = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0648\u0644\u06af\u0627\u06af\u0631\u0627\u062f",
               "VST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0648\u0644\u06af\u0627\u06af\u0631\u0627\u062f",
               "VST",
               "\u0648\u0642\u062a \u0648\u0644\u06af\u0627\u06af\u0631\u0627\u062f",
               "VT",
            };
        final String[] Iran = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0627\u06cc\u0631\u0627\u0646",
               "IST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0627\u06cc\u0631\u0627\u0646",
               "IDT",
               "\u0648\u0642\u062a \u0627\u06cc\u0631\u0627\u0646",
               "IT",
            };
        final String[] Easter = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u062c\u0632\u06cc\u0631\u0647\u0654 \u0627\u06cc\u0633\u062a\u0631",
               "EIST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u062c\u0632\u06cc\u0631\u0647\u0654 \u0627\u06cc\u0633\u062a\u0631",
               "EIST",
               "\u0648\u0642\u062a \u062c\u0632\u06cc\u0631\u0647\u0654 \u0627\u06cc\u0633\u062a\u0631",
               "EIT",
            };
        final String[] Tajikistan = new String[] {
               "\u0648\u0642\u062a \u062a\u0627\u062c\u06cc\u06a9\u0633\u062a\u0627\u0646",
               "TT",
               "Tajikistan Summer Time",
               "TST",
               "Tajikistan Time",
               "TT",
            };
        final String[] Tonga = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u062a\u0648\u0646\u06af\u0627",
               "TST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u062a\u0648\u0646\u06af\u0627",
               "TST",
               "\u0648\u0642\u062a \u062a\u0648\u0646\u06af\u0627",
               "TT",
            };
        final String[] Bangladesh = new String[] {
               "\u0648\u0642\u062a \u0628\u0646\u06af\u0644\u0627\u062f\u0634",
               "BST",
               "Bangladesh Summer Time",
               "BST",
               "Bangladesh Time",
               "BT",
            };
        final String[] Peru = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u067e\u0631\u0648",
               "PST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u067e\u0631\u0648",
               "PST",
               "\u0648\u0642\u062a \u067e\u0631\u0648",
               "PT",
            };
        final String[] Greenland_Western = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u063a\u0631\u0628 \u06af\u0631\u0648\u0626\u0646\u0644\u0646\u062f",
               "WGST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u063a\u0631\u0628 \u06af\u0631\u0648\u0626\u0646\u0644\u0646\u062f",
               "WGST",
               "\u0648\u0642\u062a \u063a\u0631\u0628 \u06af\u0631\u0648\u0626\u0646\u0644\u0646\u062f",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "\u0648\u0642\u062a \u0627\u06a9\u0648\u0627\u062f\u0648\u0631",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0634\u0631\u0642 \u06af\u0631\u0648\u0626\u0646\u0644\u0646\u062f",
               "EGST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0634\u0631\u0642 \u06af\u0631\u0648\u0626\u0646\u0644\u0646\u062f",
               "EGST",
               "\u0648\u0642\u062a \u0634\u0631\u0642 \u06af\u0631\u0648\u0626\u0646\u0644\u0646\u062f",
               "EGT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u0648\u0642\u062a \u0634\u0631\u0642 \u0627\u0646\u062f\u0648\u0646\u0632\u06cc",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Korea = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u06a9\u0631\u0647",
               "KST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u06a9\u0631\u0647",
               "KDT",
               "\u0648\u0642\u062a \u06a9\u0631\u0647",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u063a\u0631\u0628 \u0627\u0633\u062a\u0631\u0627\u0644\u06cc\u0627",
               "AWST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u063a\u0631\u0628 \u0627\u0633\u062a\u0631\u0627\u0644\u06cc\u0627",
               "AWDT",
               "\u0648\u0642\u062a \u063a\u0631\u0628 \u0627\u0633\u062a\u0631\u0627\u0644\u06cc\u0627",
               "WAT",
            };
        final String[] Kyrgystan = new String[] {
               "\u0648\u0642\u062a \u0642\u0631\u0642\u06cc\u0632\u0633\u062a\u0627\u0646",
               "KT",
               "Kyrgystan Summer Time",
               "KST",
               "Kyrgystan Time",
               "KT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u0648\u0642\u062a \u063a\u0631\u0628 \u0627\u0646\u062f\u0648\u0646\u0632\u06cc",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0634\u0631\u0642 \u0627\u0633\u062a\u0631\u0627\u0644\u06cc\u0627",
               "AEST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0634\u0631\u0642 \u0627\u0633\u062a\u0631\u0627\u0644\u06cc\u0627",
               "AEDT",
               "\u0648\u0642\u062a \u0634\u0631\u0642 \u0627\u0633\u062a\u0631\u0627\u0644\u06cc\u0627",
               "EAT",
            };
        final String[] French_Guiana = new String[] {
               "\u0648\u0642\u062a \u06af\u0648\u06cc\u0627\u0646 \u0641\u0631\u0627\u0646\u0633\u0647",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Colombia = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u06a9\u0644\u0645\u0628\u06cc\u0627",
               "CST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u06a9\u0644\u0645\u0628\u06cc\u0627",
               "CST",
               "\u0648\u0642\u062a \u06a9\u0644\u0645\u0628\u06cc\u0627",
               "CT",
            };
        final String[] Chile = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0634\u06cc\u0644\u06cc",
               "CST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0634\u06cc\u0644\u06cc",
               "CST",
               "\u0648\u0642\u062a \u0634\u06cc\u0644\u06cc",
               "CT",
            };
        final String[] America_Mountain = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u06a9\u0648\u0647\u0633\u062a\u0627\u0646\u06cc \u0627\u0645\u0631\u06cc\u06a9\u0627",
               "MST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u06a9\u0648\u0647\u0633\u062a\u0627\u0646\u06cc \u0627\u0645\u0631\u06cc\u06a9\u0627",
               "MDT",
               "\u0648\u0642\u062a \u06a9\u0648\u0647\u0633\u062a\u0627\u0646\u06cc \u0627\u0645\u0631\u06cc\u06a9\u0627",
               "MT",
            };
        final String[] Arabian = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0639\u0631\u0628\u0633\u062a\u0627\u0646",
               "AST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0639\u0631\u0628\u0633\u062a\u0627\u0646",
               "ADT",
               "\u0648\u0642\u062a \u0639\u0631\u0628\u0633\u062a\u0627\u0646",
               "AT",
            };
        final String[] Alaska = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0622\u0644\u0627\u0633\u06a9\u0627",
               "AKST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0622\u0644\u0627\u0633\u06a9\u0627",
               "AKDT",
               "\u0648\u0642\u062a \u0622\u0644\u0627\u0633\u06a9\u0627",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0648\u0644\u0627\u062f\u06cc\u200c\u0648\u0633\u062a\u0648\u06a9",
               "VST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0648\u0644\u0627\u062f\u06cc\u200c\u0648\u0633\u062a\u0648\u06a9",
               "VST",
               "\u0648\u0642\u062a \u0648\u0644\u0627\u062f\u06cc\u200c\u0648\u0633\u062a\u0648\u06a9",
               "VT",
            };
        final String[] Irkutsk = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0627\u06cc\u0631\u06a9\u0648\u062a\u0633\u06a9",
               "IST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0627\u06cc\u0631\u06a9\u0648\u062a\u0633\u06a9",
               "IST",
               "\u0648\u0642\u062a \u0627\u06cc\u0631\u06a9\u0648\u062a\u0633\u06a9",
               "IT",
            };
        final String[] Georgia = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u06af\u0631\u062c\u0633\u062a\u0627\u0646",
               "GST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u06af\u0631\u062c\u0633\u062a\u0627\u0646",
               "GST",
               "\u0648\u0642\u062a \u06af\u0631\u062c\u0633\u062a\u0627\u0646",
               "GT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u0648\u0642\u062a \u067e\u0627\u067e\u0648\u0627 \u06af\u06cc\u0646\u0647\u0654 \u0646\u0648",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Noronha = new String[] {
               "\u0633\u0627\u0639\u062a \u0639\u0627\u062f\u06cc \u0641\u0631\u0646\u0627\u0646\u062f\u0648 \u062f\u06cc \u0646\u0648\u0631\u0648\u0646\u06cc\u0627",
               "FNST",
               "\u0633\u0627\u0639\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0641\u0631\u0646\u0627\u0646\u062f\u0648 \u062f\u06cc \u0646\u0648\u0631\u0648\u0646\u06cc\u0627",
               "FNST",
               "\u0633\u0627\u0639\u062a \u0641\u0631\u0646\u0627\u0646\u062f\u0648 \u062f\u06cc \u0646\u0648\u0631\u0648\u0646\u06cc\u0627",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0686\u0648\u06cc\u0628\u0627\u0644\u0633\u0627\u0646",
               "CST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0686\u0648\u06cc\u0628\u0627\u0644\u0633\u0627\u0646",
               "CST",
               "\u0648\u0642\u062a \u0686\u0648\u06cc\u0628\u0627\u0644\u0633\u0627\u0646",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0628\u0631\u0627\u0632\u06cc\u0644\u06cc\u0627",
               "BST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0628\u0631\u0627\u0632\u06cc\u0644\u06cc\u0627",
               "BST",
               "\u0648\u0642\u062a \u0628\u0631\u0627\u0632\u06cc\u0644\u06cc\u0627",
               "BT",
            };
        final String[] China = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0686\u06cc\u0646",
               "CST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0686\u06cc\u0646",
               "CDT",
               "\u0648\u0642\u062a \u0686\u06cc\u0646",
               "CT",
            };
        final String[] Armenia = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0627\u0631\u0645\u0646\u0633\u062a\u0627\u0646",
               "AST",
               "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc \u0627\u0631\u0645\u0646\u0633\u062a\u0627\u0646",
               "AST",
               "\u0648\u0642\u062a \u0627\u0631\u0645\u0646\u0633\u062a\u0627\u0646",
               "AT",
            };
        final String[] India = new String[] {
               "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc \u0647\u0646\u062f",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "\u0648\u0642\u062a \u062c\u0632\u0627\u06cc\u0631 \u06a9\u0648\u06a9",
               "CIST",
               "Cook Islands Half Summer Time",
               "CIHST",
               "Cook Islands Time",
               "CIT",
            };
        final Object[][] data = new Object[][] {
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London", GMT },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "America/Chicago", America_Central },
            { "Asia/Kashgar", China },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", GMT },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Johns", Newfoundland },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "America/Denver", America_Mountain },
            { "Africa/Bamako", GMT },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Asia/Shanghai", China },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Europe/Paris", Europe_Central },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "America/Indianapolis", America_Eastern },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "America/Mazatlan", America_Mountain },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Samoa },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin", GMT },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "America/Sitka", Alaska },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Asia/Jerusalem", Israel },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Resolute", America_Central },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "Africa/Casablanca", Europe_Western },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "America/Phoenix", America_Mountain },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Asia/Tbilisi", Georgia },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/New_York", America_Eastern },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Africa/Monrovia", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Tokyo", Japan },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "America/Los_Angeles", America_Pacific },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
