/*
 * Copyright (c) 2012, 2014, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.de;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_de extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "001", "Welt" },
            { "002", "Afrika" },
            { "003", "Nordamerika" },
            { "005", "S\u00fcdamerika" },
            { "009", "Ozeanien" },
            { "011", "Westafrika" },
            { "013", "Mittelamerika" },
            { "014", "Ostafrika" },
            { "015", "Nordafrika" },
            { "017", "Zentralafrika" },
            { "018", "S\u00fcdliches Afrika" },
            { "019", "Amerika" },
            { "021", "N\u00f6rdliches Amerika" },
            { "029", "Karibik" },
            { "030", "Ostasien" },
            { "034", "S\u00fcdasien" },
            { "035", "S\u00fcdostasien" },
            { "039", "S\u00fcdeuropa" },
            { "053", "Australien und Neuseeland" },
            { "054", "Melanesien" },
            { "057", "Mikronesisches Inselgebiet" },
            { "061", "Polynesien" },
            { "142", "Asien" },
            { "143", "Zentralasien" },
            { "145", "Westasien" },
            { "150", "Europa" },
            { "151", "Osteuropa" },
            { "154", "Nordeuropa" },
            { "155", "Westeuropa" },
            { "419", "Lateinamerika" },
            { "AC", "Ascension" },
            { "AD", "Andorra" },
            { "AE", "Vereinigte Arabische Emirate" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua und Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanien" },
            { "AM", "Armenien" },
            { "AN", "Niederl\u00e4ndische Antillen" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentinien" },
            { "AS", "Amerikanisch-Samoa" },
            { "AT", "\u00d6sterreich" },
            { "AU", "Australien" },
            { "AW", "Aruba" },
            { "AX", "Alandinseln" },
            { "AZ", "Aserbaidschan" },
            { "BA", "Bosnien und Herzegowina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesch" },
            { "BE", "Belgien" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarien" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei Darussalam" },
            { "BO", "Bolivien" },
            { "BR", "Brasilien" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Bouvetinsel" },
            { "BW", "Botsuana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokosinseln" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Zentralafrikanische Republik" },
            { "CG", "Kongo-Brazzaville" },
            { "CH", "Schweiz" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Cookinseln" },
            { "CL", "Chile" },
            { "CM", "Kamerun" },
            { "CN", "China" },
            { "CO", "Kolumbien" },
            { "CP", "Clipperton-Insel" },
            { "CR", "Costa Rica" },
            { "CS", "Serbien und Montenegro" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CX", "Weihnachtsinsel" },
            { "CY", "Zypern" },
            { "CZ", "Tschechische Republik" },
            { "DE", "Deutschland" },
            { "DG", "Diego Garcia" },
            { "DJ", "Dschibuti" },
            { "DK", "D\u00e4nemark" },
            { "DM", "Dominica" },
            { "DO", "Dominikanische Republik" },
            { "DZ", "Algerien" },
            { "EA", "Ceuta und Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estland" },
            { "EG", "\u00c4gypten" },
            { "EH", "Westsahara" },
            { "ER", "Eritrea" },
            { "ES", "Spanien" },
            { "ET", "\u00c4thiopien" },
            { "EU", "Europ\u00e4ische Union" },
            { "FI", "Finnland" },
            { "FJ", "Fidschi" },
            { "FK", "Falklandinseln" },
            { "FM", "Mikronesien" },
            { "FO", "F\u00e4r\u00f6er" },
            { "FR", "Frankreich" },
            { "FX", "Metropolitan-Frankreich" },
            { "GA", "Gabun" },
            { "GB", "Vereinigtes K\u00f6nigreich" },
            { "GD", "Grenada" },
            { "GE", "Georgien" },
            { "GF", "Franz\u00f6sisch-Guayana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Gr\u00f6nland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "\u00c4quatorialguinea" },
            { "GR", "Griechenland" },
            { "GS", "S\u00fcdgeorgien und die S\u00fcdlichen Sandwichinseln" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Sonderverwaltungszone Hongkong" },
            { "HM", "Heard- und McDonald-Inseln" },
            { "HN", "Honduras" },
            { "HR", "Kroatien" },
            { "HT", "Haiti" },
            { "HU", "Ungarn" },
            { "IC", "Kanarische Inseln" },
            { "ID", "Indonesien" },
            { "IE", "Irland" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "Indien" },
            { "IO", "Britisches Territorium im Indischen Ozean" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italien" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordanien" },
            { "JP", "Japan" },
            { "KE", "Kenia" },
            { "KG", "Kirgisistan" },
            { "KH", "Kambodscha" },
            { "KI", "Kiribati" },
            { "KM", "Komoren" },
            { "KN", "St. Kitts und Nevis" },
            { "KP", "Demokratische Volksrepublik Korea" },
            { "KR", "Republik Korea" },
            { "KW", "Kuwait" },
            { "KY", "Kaimaninseln" },
            { "KZ", "Kasachstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "St. Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Litauen" },
            { "LU", "Luxemburg" },
            { "LV", "Lettland" },
            { "LY", "Libyen" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Republik Moldau" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshallinseln" },
            { "MK", "Mazedonien" },
            { "ML", "Mali" },
            { "MM", "Myanmar" },
            { "MN", "Mongolei" },
            { "MO", "Sonderverwaltungszone Macao" },
            { "MP", "N\u00f6rdliche Marianen" },
            { "MQ", "Martinique" },
            { "MR", "Mauretanien" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Malediven" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "MY", "Malaysia" },
            { "MZ", "Mosambik" },
            { "NA", "Namibia" },
            { "NC", "Neukaledonien" },
            { "NE", "Niger" },
            { "NF", "Norfolkinsel" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Niederlande" },
            { "NO", "Norwegen" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Neuseeland" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Franz\u00f6sisch-Polynesien" },
            { "PG", "Papua-Neuguinea" },
            { "PH", "Philippinen" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "PM", "St. Pierre und Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Pal\u00e4stinensische Autonomiegebiete" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Katar" },
            { "QO", "\u00c4u\u00dferes Ozeanien" },
            { "RE", "R\u00e9union" },
            { "RO", "Rum\u00e4nien" },
            { "RS", "Serbien" },
            { "RU", "Russische F\u00f6deration" },
            { "RW", "Ruanda" },
            { "SA", "Saudi-Arabien" },
            { "SB", "Salomonen" },
            { "SC", "Seychellen" },
            { "SD", "Sudan" },
            { "SE", "Schweden" },
            { "SG", "Singapur" },
            { "SH", "St. Helena" },
            { "SI", "Slowenien" },
            { "SJ", "Svalbard und Jan Mayen" },
            { "SK", "Slowakei" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "ST", "S\u00e3o Tom\u00e9 und Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SY", "Syrien" },
            { "SZ", "Swasiland" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- und Caicosinseln" },
            { "TD", "Tschad" },
            { "TF", "Franz\u00f6sische S\u00fcd- und Antarktisgebiete" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadschikistan" },
            { "TK", "Tokelau" },
            { "TL", "Osttimor" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunesien" },
            { "TO", "Tonga" },
            { "TR", "T\u00fcrkei" },
            { "TT", "Trinidad und Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansania" },
            { "UA", "Ukraine" },
            { "UG", "Uganda" },
            { "UM", "Amerikanisch-Ozeanien" },
            { "US", "Vereinigte Staaten" },
            { "UY", "Uruguay" },
            { "UZ", "Usbekistan" },
            { "VA", "Vatikanstadt" },
            { "VC", "St. Vincent und die Grenadinen" },
            { "VE", "Venezuela" },
            { "VG", "Britische Jungferninseln" },
            { "VI", "Amerikanische Jungferninseln" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis und Futuna" },
            { "WS", "Samoa" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "S\u00fcdafrika" },
            { "ZM", "Sambia" },
            { "ZW", "Simbabwe" },
            { "ZZ", "Unbekannte Region" },
            { "aa", "Afar" },
            { "ab", "Abchasisch" },
            { "ae", "Avestisch" },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Amharisch" },
            { "an", "Aragonesisch" },
            { "ar", "Arabisch" },
            { "as", "Assamesisch" },
            { "av", "Awarisch" },
            { "ay", "Aymara" },
            { "az", "Aserbaidschanisch" },
            { "ba", "Baschkirisch" },
            { "be", "Wei\u00dfrussisch" },
            { "bg", "Bulgarisch" },
            { "bh", "Biharisch" },
            { "bi", "Bislama" },
            { "bm", "Bambara-Sprache" },
            { "bn", "Bengalisch" },
            { "bo", "Tibetisch" },
            { "br", "Bretonisch" },
            { "bs", "Bosnisch" },
            { "ca", "Katalanisch" },
            { "ce", "Tschetschenisch" },
            { "ch", "Chamorro-Sprache" },
            { "co", "Korsisch" },
            { "cr", "Cree" },
            { "cs", "Tschechisch" },
            { "cu", "Kirchenslawisch" },
            { "cv", "Tschuwaschisch" },
            { "cy", "Walisisch" },
            { "da", "D\u00e4nisch" },
            { "de", "Deutsch" },
            { "dv", "Maledivisch" },
            { "dz", "Bhutanisch" },
            { "ee", "Ewe-Sprache" },
            { "el", "Griechisch" },
            { "en", "Englisch" },
            { "eo", "Esperanto" },
            { "es", "Spanisch" },
            { "et", "Estnisch" },
            { "eu", "Baskisch" },
            { "fa", "Persisch" },
            { "ff", "Ful" },
            { "fi", "Finnisch" },
            { "fj", "Fidschianisch" },
            { "fo", "F\u00e4r\u00f6isch" },
            { "fr", "Franz\u00f6sisch" },
            { "fy", "Friesisch" },
            { "ga", "Irisch" },
            { "gd", "Schottisches G\u00e4lisch" },
            { "gl", "Galizisch" },
            { "gn", "Guarani" },
            { "gu", "Gujarati" },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", "Hebr\u00e4isch" },
            { "hi", "Hindi" },
            { "ho", "Hiri-Motu" },
            { "hr", "Kroatisch" },
            { "ht", "Haitianisch" },
            { "hu", "Ungarisch" },
            { "hy", "Armenisch" },
            { "hz", "Herero-Sprache" },
            { "ia", "Interlingua" },
            { "id", "Indonesisch" },
            { "ie", "Interlingue" },
            { "ig", "Igbo-Sprache" },
            { "ii", "Sichuan Yi" },
            { "ik", "Inupiak" },
            { "io", "Ido-Sprache" },
            { "is", "Isl\u00e4ndisch" },
            { "it", "Italienisch" },
            { "iu", "Inukitut" },
            { "ja", "Japanisch" },
            { "jv", "Javanisch" },
            { "ka", "Georgisch" },
            { "kg", "Kongolesisch" },
            { "ki", "Kikuyu-Sprache" },
            { "kj", "Kwanyama" },
            { "kk", "Kasachisch" },
            { "kl", "Gr\u00f6nl\u00e4ndisch" },
            { "km", "Kambodschanisch" },
            { "kn", "Kannada" },
            { "ko", "Koreanisch" },
            { "kr", "Kanuri-Sprache" },
            { "ks", "Kaschmirisch" },
            { "ku", "Kurdisch" },
            { "kv", "Komi-Sprache" },
            { "kw", "Kornisch" },
            { "ky", "Kirgisisch" },
            { "la", "Latein" },
            { "lb", "Luxemburgisch" },
            { "lg", "Ganda-Sprache" },
            { "li", "Limburgisch" },
            { "ln", "Lingala" },
            { "lo", "Laotisch" },
            { "lt", "Litauisch" },
            { "lu", "Luba-Katanga" },
            { "lv", "Lettisch" },
            { "mg", "Malagassi-Sprache" },
            { "mh", "Marschallesisch" },
            { "mi", "Maori" },
            { "mk", "Mazedonisch" },
            { "ml", "Malayalam" },
            { "mn", "Mongolisch" },
            { "mo", "Moldauisch" },
            { "mr", "Marathi" },
            { "ms", "Malaiisch" },
            { "mt", "Maltesisch" },
            { "my", "Birmanisch" },
            { "na", "Nauruisch" },
            { "nb", "Norwegisch Bokm\u00e5l" },
            { "nd", "Nord-Ndebele-Sprache" },
            { "ne", "Nepalesisch" },
            { "ng", "Ndonga" },
            { "nl", "Niederl\u00e4ndisch" },
            { "nn", "Norwegisch Nynorsk" },
            { "no", "Norwegisch" },
            { "nr", "S\u00fcd-Ndebele-Sprache" },
            { "nv", "Navajo" },
            { "ny", "Nyanja-Sprache" },
            { "oc", "Okzitanisch" },
            { "oj", "Ojibwa-Sprache" },
            { "om", "Oromo" },
            { "or", "Orija" },
            { "os", "Ossetisch" },
            { "pa", "Pandschabisch" },
            { "pi", "Pali" },
            { "pl", "Polnisch" },
            { "ps", "Paschtu" },
            { "pt", "Portugiesisch" },
            { "qu", "Quechua" },
            { "rm", "R\u00e4toromanisch" },
            { "rn", "Rundi-Sprache" },
            { "ro", "Rum\u00e4nisch" },
            { "ru", "Russisch" },
            { "rw", "Ruandisch" },
            { "sa", "Sanskrit" },
            { "sc", "Sardisch" },
            { "sd", "Sindhi" },
            { "se", "Nord-Samisch" },
            { "sg", "Sango" },
            { "sh", "Serbo-Kroatisch" },
            { "si", "Singhalesisch" },
            { "sk", "Slowakisch" },
            { "sl", "Slowenisch" },
            { "sm", "Samoanisch" },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "sq", "Albanisch" },
            { "sr", "Serbisch" },
            { "ss", "Swazi" },
            { "st", "S\u00fcd-Sotho-Sprache" },
            { "su", "Sundanesisch" },
            { "sv", "Schwedisch" },
            { "sw", "Suaheli" },
            { "ta", "Tamilisch" },
            { "te", "Telugu" },
            { "tg", "Tadschikisch" },
            { "th", "Thail\u00e4ndisch" },
            { "ti", "Tigrinja" },
            { "tk", "Turkmenisch" },
            { "tl", "Tagalog" },
            { "tn", "Tswana-Sprache" },
            { "to", "Tongaisch" },
            { "tr", "T\u00fcrkisch" },
            { "ts", "Tsonga" },
            { "tt", "Tatarisch" },
            { "tw", "Twi" },
            { "ty", "Tahitisch" },
            { "ug", "Uigurisch" },
            { "uk", "Ukrainisch" },
            { "ur", "Urdu" },
            { "uz", "Usbekisch" },
            { "ve", "Venda-Sprache" },
            { "vi", "Vietnamesisch" },
            { "vo", "Volap\u00fck" },
            { "wa", "Wallonisch" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Jiddisch" },
            { "yo", "Yoruba" },
            { "za", "Zhuang" },
            { "zh", "Chinesisch" },
            { "zu", "Zulu" },
            { "ace", "Aceh-Sprache" },
            { "ach", "Acholi-Sprache" },
            { "ada", "Adangme" },
            { "ady", "Adygeisch" },
            { "afa", "Afroasiatisch" },
            { "afh", "Afrihili" },
            { "ain", "Ainu-Sprache" },
            { "akk", "Akkadisch" },
            { "ale", "Aleutisch" },
            { "alg", "Algonkin-Sprache" },
            { "alt", "S\u00fcd-Altaisch" },
            { "ang", "Altenglisch" },
            { "anp", "Angika" },
            { "apa", "Apache-Sprache" },
            { "arc", "Aram\u00e4isch" },
            { "arn", "Araukanisch" },
            { "arp", "Arapaho-Sprache" },
            { "art", "Kunstsprache" },
            { "arw", "Arawak-Sprache" },
            { "ast", "Asturianisch" },
            { "ath", "Athapaskisch" },
            { "aus", "Australisch" },
            { "awa", "Awadhi" },
            { "bad", "Banda-Sprache" },
            { "bai", "Bamileke-Sprache" },
            { "bal", "Belutschisch" },
            { "ban", "Balinesisch" },
            { "bas", "Basaa-Sprache" },
            { "bat", "Baltisch" },
            { "bej", "Bedauye" },
            { "bem", "Bemba-Sprache" },
            { "ber", "Berbersprache" },
            { "bho", "Bhodschpuri" },
            { "bik", "Bikol-Sprache" },
            { "bin", "Bini-Sprache" },
            { "bla", "Blackfoot-Sprache" },
            { "bnt", "Bantusprache" },
            { "bra", "Braj-Bhakha" },
            { "btk", "Batak" },
            { "bua", "Burjatisch" },
            { "bug", "Buginesisch" },
            { "byn", "Blin" },
            { "cad", "Caddo" },
            { "cai", "Zentralamerikanische Indianersprache" },
            { "car", "Karibisch" },
            { "cau", "Kaukasisch" },
            { "cch", "Atsam" },
            { "ceb", "Cebuano" },
            { "cel", "Keltisch" },
            { "chb", "Chibcha-Sprache" },
            { "chg", "Tschagataisch" },
            { "chk", "Trukesisch" },
            { "chm", "Tscheremissisch" },
            { "chn", "Chinook" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", "Cherokee" },
            { "chy", "Cheyenne" },
            { "cmc", "Cham-Sprache" },
            { "cop", "Koptisch" },
            { "cpe", "Kreolisch-Englische Sprache" },
            { "cpf", "Kreolisch-Franz\u00f6sische Sprache" },
            { "cpp", "Kreolisch-Portugiesische Sprache" },
            { "crh", "Krimtatarisch" },
            { "crp", "Kreolische Sprache" },
            { "csb", "Kaschubisch" },
            { "cus", "Kuschitisch" },
            { "dak", "Dakota-Sprache" },
            { "dar", "Darginisch" },
            { "day", "Dajak" },
            { "del", "Delaware-Sprache" },
            { "den", "Slave" },
            { "dgr", "Dogrib" },
            { "din", "Dinka-Sprache" },
            { "doi", "Dogri" },
            { "dra", "Drawidisch" },
            { "dsb", "Niedersorbisch" },
            { "dua", "Duala" },
            { "dum", "Mittelniederl\u00e4ndisch" },
            { "dyu", "Dyula-Sprache" },
            { "ebu", "Kiembu" },
            { "efi", "Efik" },
            { "egy", "\u00c4gyptisch" },
            { "eka", "Ekajuk" },
            { "elx", "Elamisch" },
            { "enm", "Mittelenglisch" },
            { "ewo", "Ewondo" },
            { "fan", "Pangwe-Sprache" },
            { "fat", "Fanti-Sprache" },
            { "fil", "Filipino" },
            { "fiu", "Finnougrisch" },
            { "fon", "Fon-Sprache" },
            { "frm", "Mittelfranz\u00f6sisch" },
            { "fro", "Altfranz\u00f6sisch" },
            { "frr", "Nordfriesisch" },
            { "frs", "Ostfriesisch" },
            { "fur", "Friulisch" },
            { "gaa", "Ga-Sprache" },
            { "gay", "Gayo" },
            { "gba", "Gbaya-Sprache" },
            { "gem", "Germanisch" },
            { "gez", "Geez" },
            { "gil", "Gilbertesisch" },
            { "gmh", "Mittelhochdeutsch" },
            { "goh", "Althochdeutsch" },
            { "gon", "Gondi-Sprache" },
            { "gor", "Mongondou" },
            { "got", "Gotisch" },
            { "grb", "Grebo-Sprache" },
            { "grc", "Altgriechisch" },
            { "gsw", "Schweizerdeutsch" },
            { "gwi", "Kutchin-Sprache" },
            { "hai", "Haida-Sprache" },
            { "haw", "Hawaiisch" },
            { "hil", "Hiligaynon-Sprache" },
            { "him", "Himachali" },
            { "hit", "Hethitisch" },
            { "hmn", "Miao-Sprache" },
            { "hsb", "Obersorbisch" },
            { "hup", "Hupa" },
            { "iba", "Iban" },
            { "ijo", "Ijo-Sprache" },
            { "ilo", "Ilokano-Sprache" },
            { "inc", "Indoarisch" },
            { "ine", "Indogermanisch" },
            { "inh", "Inguschisch" },
            { "ira", "Iranische Sprache" },
            { "iro", "Irokesische Sprache" },
            { "jbo", "Lojban" },
            { "jpr", "J\u00fcdisch-Persisch" },
            { "jrb", "J\u00fcdisch-Arabisch" },
            { "kaa", "Karakalpakisch" },
            { "kab", "Kabylisch" },
            { "kac", "Kachin-Sprache" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kar", "Karenisch" },
            { "kaw", "Kawi" },
            { "kbd", "Kabardinisch" },
            { "kcg", "Tyap" },
            { "kea", "Kabuverdianu" },
            { "kfo", "Koro" },
            { "kha", "Khasi-Sprache" },
            { "khi", "Khoisan-Sprache" },
            { "kho", "Sakisch" },
            { "kmb", "Kimbundu-Sprache" },
            { "kok", "Konkani" },
            { "kos", "Kosraeanisch" },
            { "kpe", "Kpelle-Sprache" },
            { "krc", "Karatschaiisch-Balkarisch" },
            { "krl", "Karelisch" },
            { "kro", "Kru-Sprache" },
            { "kru", "Oraon-Sprache" },
            { "kum", "Kum\u00fckisch" },
            { "kut", "Kutenai-Sprache" },
            { "lad", "Ladino" },
            { "lah", "Lahnda" },
            { "lam", "Lamba-Sprache" },
            { "lez", "Lesgisch" },
            { "lol", "Mongo" },
            { "loz", "Rotse-Sprache" },
            { "lua", "Luba-Lulua" },
            { "lui", "Luiseno-Sprache" },
            { "lun", "Lunda-Sprache" },
            { "luo", "Luo-Sprache" },
            { "lus", "Lushai-Sprache" },
            { "luy", "Olulujia" },
            { "mad", "Maduresisch" },
            { "mag", "Khotta" },
            { "mai", "Maithili" },
            { "mak", "Makassarisch" },
            { "man", "Manding-Sprache" },
            { "map", "Austronesisch" },
            { "mas", "Massai-Sprache" },
            { "mdf", "Moksha" },
            { "mdr", "Mandaresisch" },
            { "men", "Mende-Sprache" },
            { "mga", "Mittelirisch" },
            { "mic", "Micmac-Sprache" },
            { "min", "Minangkabau-Sprache" },
            { "mis", "Andere Sprache" },
            { "mkh", "Mon-Khmer-Sprache" },
            { "mnc", "Mandschurisch" },
            { "mni", "Meithei-Sprache" },
            { "mno", "Manobo-Sprache" },
            { "moh", "Mohawk-Sprache" },
            { "mos", "Mossi-Sprache" },
            { "mul", "Mehrsprachig" },
            { "mun", "Munda-Sprache" },
            { "mus", "Muskogee-Sprache" },
            { "mwl", "Mirandesisch" },
            { "mwr", "Marwari" },
            { "myn", "Maya-Sprache" },
            { "myv", "Ersja-Mordwinisch" },
            { "nah", "Nahuatl" },
            { "nai", "Nordamerikanische Indianersprache" },
            { "nap", "Neapolitanisch" },
            { "nds", "Niederdeutsch" },
            { "new", "Newari" },
            { "nia", "Nias-Sprache" },
            { "nic", "Nigerkordofanisch" },
            { "niu", "Niue-Sprache" },
            { "nog", "Nogai" },
            { "non", "Altnordisch" },
            { "nqo", "N\u2019Ko" },
            { "nso", "Nord-Sotho-Sprache" },
            { "nub", "Nubisch" },
            { "nwc", "Alt-Newari" },
            { "nym", "Nyamwezi-Sprache" },
            { "nyn", "Nyankole" },
            { "nyo", "Nyoro" },
            { "nzi", "Nzima" },
            { "osa", "Osage-Sprache" },
            { "ota", "Osmanisch" },
            { "oto", "Otomangue-Sprache" },
            { "paa", "Papuasprache" },
            { "pag", "Pangasinan-Sprache" },
            { "pal", "Mittelpersisch" },
            { "pam", "Pampanggan-Sprache" },
            { "pap", "Papiamento" },
            { "pau", "Palau" },
            { "peo", "Altpersisch" },
            { "phi", "Philippinen-Austronesisch" },
            { "phn", "Ph\u00f6nikisch" },
            { "pon", "Ponapeanisch" },
            { "pra", "Prakrit" },
            { "pro", "Altprovenzalisch" },
            { "raj", "Rajasthani" },
            { "rap", "Osterinsel-Sprache" },
            { "rar", "Rarotonganisch" },
            { "roa", "Romanische Sprache" },
            { "rom", "Romani" },
            { "rup", "Aromunisch" },
            { "sad", "Sandawe-Sprache" },
            { "sah", "Jakutisch" },
            { "sai", "S\u00fcdamerikanische Indianersprache" },
            { "sal", "Salish-Sprache" },
            { "sam", "Samaritanisch" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "scn", "Sizilianisch" },
            { "sco", "Schottisch" },
            { "sel", "Selkupisch" },
            { "sem", "Semitisch" },
            { "sga", "Altirisch" },
            { "sgn", "Geb\u00e4rdensprache" },
            { "shn", "Schan-Sprache" },
            { "sid", "Sidamo" },
            { "sio", "Sioux-Sprache" },
            { "sit", "Sinotibetisch" },
            { "sla", "Slawisch" },
            { "sma", "S\u00fcd-Samisch" },
            { "smi", "Lappisch" },
            { "smj", "Lule-Lappisch" },
            { "smn", "Inari-Lappisch" },
            { "sms", "Skolt-Lappisch" },
            { "snk", "Soninke-Sprache" },
            { "sog", "Sogdisch" },
            { "son", "Songhai-Sprache" },
            { "srn", "Srananisch" },
            { "srr", "Serer-Sprache" },
            { "ssa", "Nilosaharanisch" },
            { "suk", "Sukuma-Sprache" },
            { "sus", "Susu" },
            { "sux", "Sumerisch" },
            { "swb", "Komorisch" },
            { "syc", "Altsyrisch" },
            { "syr", "Syrisch" },
            { "tai", "Tai-Sprache" },
            { "tem", "Temne" },
            { "ter", "Tereno-Sprache" },
            { "tet", "Tetum-Sprache" },
            { "tig", "Tigre" },
            { "tiv", "Tiv-Sprache" },
            { "tkl", "Tokelauanisch" },
            { "tlh", "Klingonisch" },
            { "tli", "Tlingit-Sprache" },
            { "tmh", "Tamaseq" },
            { "tog", "Tsonga-Sprache" },
            { "tpi", "Neumelanesisch" },
            { "tsi", "Tsimshian-Sprache" },
            { "tum", "Tumbuka-Sprache" },
            { "tup", "Tupi-Sprache" },
            { "tut", "Altaisch" },
            { "tvl", "Elliceanisch" },
            { "tyv", "Tuwinisch" },
            { "udm", "Udmurtisch" },
            { "uga", "Ugaritisch" },
            { "umb", "Mbundu-Sprache" },
            { "und", "Unbestimmte Sprache" },
            { "vai", "Vai-Sprache" },
            { "vot", "Wotisch" },
            { "wak", "Wakashanisch" },
            { "wal", "Walamo-Sprache" },
            { "war", "Waray" },
            { "was", "Washo-Sprache" },
            { "wen", "Sorbisch" },
            { "xal", "Kalm\u00fcckisch" },
            { "yao", "Yao-Sprache" },
            { "yap", "Yapesisch" },
            { "ypk", "Yupik-Sprache" },
            { "yue", "Kantonesisch" },
            { "zap", "Zapotekisch" },
            { "zbl", "Bliss-Symbole" },
            { "zen", "Zenaga" },
            { "znd", "Zande-Sprache" },
            { "zun", "Zuni-Sprache" },
            { "zxx", "Keine Sprachinhalte" },
            { "zza", "Zaza" },
            { "Arab", "Arabisch" },
            { "Armi", "Armi" },
            { "Armn", "Armenisch" },
            { "Avst", "Avestisch" },
            { "Bali", "Balinesisch" },
            { "Batk", "Battakisch" },
            { "Beng", "Bengalisch" },
            { "Blis", "Bliss-Symbole" },
            { "Bopo", "Bopomofo" },
            { "Brah", "Brahmi" },
            { "Brai", "Blindenschrift" },
            { "Bugi", "Buginesisch" },
            { "Buhd", "Buhid" },
            { "Cans", "UCAS" },
            { "Cari", "Karisch" },
            { "Cham", "Cham" },
            { "Cher", "Cherokee" },
            { "Cirt", "Cirth" },
            { "Copt", "Koptisch" },
            { "Cprt", "Zypriotisch" },
            { "Cyrl", "Kyrillisch" },
            { "Cyrs", "Altkirchenslawisch" },
            { "Deva", "Devanagari" },
            { "Dsrt", "Deseret" },
            { "Egyd", "\u00c4gyptisch - Demotisch" },
            { "Egyh", "\u00c4gyptisch - Hieratisch" },
            { "Egyp", "\u00c4gyptische Hieroglyphen" },
            { "Ethi", "\u00c4thiopisch" },
            { "Geok", "Khutsuri" },
            { "Geor", "Georgisch" },
            { "Glag", "Glagolitisch" },
            { "Goth", "Gotisch" },
            { "Grek", "Griechisch" },
            { "Gujr", "Gujarati" },
            { "Guru", "Gurmukhi" },
            { "Hang", "Hangul" },
            { "Hani", "Chinesisch" },
            { "Hano", "Hanunoo" },
            { "Hans", "Vereinfacht" },
            { "Hant", "Traditionell" },
            { "Hebr", "Hebr\u00e4isch" },
            { "Hira", "Hiragana" },
            { "Hmng", "Pahawh Hmong" },
            { "Hrkt", "Katakana oder Hiragana" },
            { "Hung", "Altungarisch" },
            { "Inds", "Indus-Schrift" },
            { "Ital", "Altitalisch" },
            { "Java", "Javanesisch" },
            { "Jpan", "Japanisch" },
            { "Kali", "Kayah Li" },
            { "Kana", "Katakana" },
            { "Khar", "Kharoshthi" },
            { "Khmr", "Khmer" },
            { "Knda", "Kannada" },
            { "Kore", "Koreanisch" },
            { "Lana", "Lanna" },
            { "Laoo", "Laotisch" },
            { "Latf", "Lateinisch - Fraktur-Variante" },
            { "Latg", "Lateinisch - G\u00e4lische Variante" },
            { "Latn", "Lateinisch" },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Linear A" },
            { "Linb", "Linear B" },
            { "Lyci", "Lykisch" },
            { "Lydi", "Lydisch" },
            { "Mand", "Mand\u00e4isch" },
            { "Mani", "Manich\u00e4isch" },
            { "Maya", "Maya-Hieroglyphen" },
            { "Mero", "Meroitisch" },
            { "Mlym", "Malaysisch" },
            { "Mong", "Mongolisch" },
            { "Moon", "Moon" },
            { "Mtei", "Meitei Mayek" },
            { "Mymr", "Birmanisch" },
            { "Nkoo", "N\u2019Ko" },
            { "Ogam", "Ogham" },
            { "Olck", "Ol Chiki" },
            { "Orkh", "Orchon-Runen" },
            { "Orya", "Oriya" },
            { "Osma", "Osmanisch" },
            { "Perm", "Altpermisch" },
            { "Phag", "Phags-pa" },
            { "Phlv", "Pahlavi" },
            { "Phnx", "Ph\u00f6nizisch" },
            { "Plrd", "Pollard Phonetisch" },
            { "Rjng", "Rejang" },
            { "Roro", "Rongorongo" },
            { "Runr", "Runenschrift" },
            { "Samr", "Samaritanisch" },
            { "Sara", "Sarati" },
            { "Saur", "Saurashtra" },
            { "Sgnw", "Geb\u00e4rdensprache" },
            { "Shaw", "Shaw-Alphabet" },
            { "Sinh", "Singhalesisch" },
            { "Sund", "Sundanesisch" },
            { "Sylo", "Syloti Nagri" },
            { "Syrc", "Syrisch" },
            { "Syre", "Syrisch - Estrangelo-Variante" },
            { "Syrj", "Westsyrisch" },
            { "Syrn", "Ostsyrisch" },
            { "Tagb", "Tagbanwa" },
            { "Tale", "Tai Le" },
            { "Talu", "Tai Lue" },
            { "Taml", "Tamilisch" },
            { "Telu", "Telugu" },
            { "Teng", "Tengwar" },
            { "Tfng", "Tifinagh" },
            { "Tglg", "Tagalog" },
            { "Thaa", "Thaana" },
            { "Thai", "Thai" },
            { "Tibt", "Tibetisch" },
            { "Ugar", "Ugaritisch" },
            { "Vaii", "Vai" },
            { "Visp", "Sichtbare Sprache" },
            { "Xpeo", "Altpersisch" },
            { "Xsux", "Sumerisch-akkadische Keilschrift" },
            { "Yiii", "Yi" },
            { "Zinh", "Geerbter Schriftwert" },
            { "Zxxx", "Schriftlos" },
            { "Zyyy", "Unbestimmt" },
            { "Zzzz", "Uncodierte Schrift" },
            { "root", "Root" },
            { "de_AT", "\u00d6sterreichisches Deutsch" },
            { "de_CH", "Schweizer Hochdeutsch" },
            { "en_AU", "Australisches Englisch" },
            { "en_CA", "Kanadisches Englisch" },
            { "en_GB", "Britisches Englisch" },
            { "en_US", "Amerikanisches Englisch" },
            { "es_ES", "Iberisches Spanisch" },
            { "fr_CA", "Kanadisches Franz\u00f6sisch" },
            { "fr_CH", "Schweizer Franz\u00f6sisch" },
            { "nl_BE", "Fl\u00e4misch" },
            { "pt_BR", "Brasilianisches Portugiesisch" },
            { "pt_PT", "Iberisches Portugiesisch" },
            { "es_419", "Lateinamerikanisches Spanisch" },
            { "zh_Hans", "Chinesisch (vereinfacht)" },
            { "zh_Hant", "Chinesisch (traditionell)" },
        };
        return data;
    }
}
