/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import processing.core.PApplet;
import processing.data.Table;
import processing.data.XML;

public class TableODS
extends Table {
    public TableODS(File odsFile) {
        this(TableODS.getContentXML(odsFile), null, false);
    }

    public TableODS(File odsFile, boolean actual) {
        this(TableODS.getContentXML(odsFile), null, actual);
    }

    public TableODS(PApplet parent, String filename) {
        this(TableODS.getContentXML(parent.createInput(filename)), null, false);
    }

    public TableODS(PApplet parent, String filename, boolean actual) {
        this(TableODS.getContentXML(parent.createInput(filename)), null, actual);
    }

    public TableODS(PApplet parent, String filename, String worksheet, boolean actual) {
        this(TableODS.getContentXML(parent.createInput(filename)), worksheet, actual);
    }

    protected TableODS(InputStream input, String worksheet, boolean actual) {
        try {
            this.read(input, worksheet, actual);
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    protected void read(InputStream input, String worksheet, boolean actual) throws IOException, ParserConfigurationException, SAXException {
        XML[] sheets;
        XML xml = new XML(input);
        XML[] xMLArray = sheets = xml.getChildren("office:body/office:spreadsheet/table:table");
        int n = sheets.length;
        int n2 = 0;
        while (n2 < n) {
            XML sheet = xMLArray[n2];
            if (worksheet == null || worksheet.equals(sheet.getString("table:name"))) {
                this.parseSheet(sheet, actual);
            }
            ++n2;
        }
    }

    protected void parseSheet(XML sheet, boolean actual) {
        XML[] rows = sheet.getChildren("table:table-row");
        int rowIndex = 0;
        XML[] xMLArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            XML row = xMLArray[n2];
            int rowRepeat = row.getInt("table:number-rows-repeated", 1);
            boolean rowNotNull = false;
            XML[] cells = row.getChildren();
            int columnIndex = 0;
            XML[] xMLArray2 = cells;
            int n3 = cells.length;
            int n4 = 0;
            while (n4 < n3) {
                int cellKids;
                String cellData;
                XML cell = xMLArray2[n4];
                int cellRepeat = cell.getInt("table:number-columns-repeated", 1);
                String string = cellData = actual ? cell.getString("office:value") : null;
                if (cellData == null && (cellKids = cell.getChildCount()) != 0) {
                    XML[] paragraphElements = cell.getChildren("text:p");
                    if (paragraphElements.length != 1) {
                        XML[] xMLArray3 = paragraphElements;
                        int n5 = paragraphElements.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            XML el = xMLArray3[n6];
                            System.err.println(el.toString());
                            ++n6;
                        }
                        throw new RuntimeException("found more than one text:p element");
                    }
                    XML textp = paragraphElements[0];
                    String textpContent = textp.getContent();
                    if (textpContent != null) {
                        cellData = textpContent;
                    } else {
                        XML[] textpKids = textp.getChildren();
                        StringBuffer cellBuffer = new StringBuffer();
                        XML[] xMLArray4 = textpKids;
                        int n7 = textpKids.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            XML kid = xMLArray4[n8];
                            String kidName = kid.getName();
                            if (kidName == null) {
                                this.appendNotNull(kid, cellBuffer);
                            } else if (kidName.equals("text:s")) {
                                int spaceCount = kid.getInt("text:c", 1);
                                int space = 0;
                                while (space < spaceCount) {
                                    cellBuffer.append(' ');
                                    ++space;
                                }
                            } else if (kidName.equals("text:span")) {
                                this.appendNotNull(kid, cellBuffer);
                            } else if (kidName.equals("text:a")) {
                                if (actual) {
                                    cellBuffer.append(kid.getString("xlink:href"));
                                } else {
                                    this.appendNotNull(kid, cellBuffer);
                                }
                            } else {
                                this.appendNotNull(kid, cellBuffer);
                                System.err.println(String.valueOf(this.getClass().getName()) + ": don't understand: " + kid);
                            }
                            ++n8;
                        }
                        cellData = cellBuffer.toString();
                    }
                }
                int r = 0;
                while (r < cellRepeat) {
                    if (cellData != null) {
                        this.setString(rowIndex, columnIndex, cellData);
                    }
                    ++columnIndex;
                    if (cellData != null) {
                        rowNotNull = true;
                    }
                    ++r;
                }
                ++n4;
            }
            if (rowNotNull && rowRepeat > 1) {
                Object[] rowStrings = this.getStringRow(rowIndex);
                int r = 1;
                while (r < rowRepeat) {
                    this.addRow(rowStrings);
                    ++r;
                }
            }
            rowIndex += rowRepeat;
            ++n2;
        }
    }

    protected void appendNotNull(XML kid, StringBuffer buffer) {
        String content = kid.getContent();
        if (content != null) {
            buffer.append(content);
        }
    }

    protected static InputStream getContentXML(File file) {
        try {
            ZipFile zip = new ZipFile(file);
            ZipEntry entry = zip.getEntry("content.xml");
            return zip.getInputStream(entry);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static InputStream getContentXML(InputStream input) {
        ZipInputStream zis = new ZipInputStream(input);
        ZipEntry entry = null;
        try {
            while ((entry = zis.getNextEntry()) != null) {
                if (!entry.getName().equals("content.xml")) continue;
                return zis;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

