import java.util.Date;
import java.util.List;

public class SpeedTest {
    
    public static void main(String[] args)
    {

	try{
	    //	    Hasher<String> hasher = new GenericHasher<String>();
	    Hasher<String> hasher = new StringHasher3();
	    int hashTableSize = 140000;

	    HashTable<String,Integer> t = 
		new HashTable<String,Integer>(hashTableSize,
					      hasher);

	    FileParser fp = new FileParser("WarAndPeace.txt");
	    List<String> words = fp.getAllWords();
	    Date startTime1 = new Date();
	    //add all the words
	    for(String word : words){
		Integer i = t.get(word);
		if (i == null) {
		    t.put(word, 1);
		} else {
		    t.put(word,i+1);
		}
	    }
	    Date endTime1 = new Date();
	    System.out.println("Time: " +  (endTime1.getTime() - startTime1.getTime()));
	    System.out.println(t.calculateStats());
	    //	    System.out.println("load " + t.load);

	    //now, find the most common word in the dictionary
	    FileParser dict = new FileParser("TWL06.txt");
	    List<String> dictWords = dict.getAllWords();
	    int bestOccurances = 0;
	    String mostCommon = null;
	    Date startTime2 = new Date();
	    for (int i = 0; i < 100; i++){
		for(String word : dictWords){
		    Integer wordOccurances = t.get(word);
		    if(wordOccurances != null && wordOccurances > bestOccurances){
			bestOccurances = wordOccurances;
			mostCommon = word;
		    }
		}
	    }
	    Date endTime2 = new Date();
	    System.out.println("Time: " +  (endTime2.getTime() - startTime2.getTime()));

	    System.out.println(mostCommon);
	    //	    	    System.out.println(t);
	} catch (Exception e){e.printStackTrace();}
    }
}


