/**
 * 
 */
package lecture11;

/**
 * This class represents a 2d point object. 
 * @author Joanna Klukowska
 *
 */
public class Point  implements Comparable<Point>{
	private double x, y;	//point coordinates
	
	/**
	 * Create 2D point object with specified coordinates.
	 * @param x x-coordinate of this point object
	 * @param y y-coordinate of this point object 
	 */
	public Point (int x, int y )
	{
		this.x = x;
		this.y = y;
	}
	
	/**
	 * Create 2D point object representing the origin (0.0, 0.0)
	 */
	public Point() {
		this(0,0);
	}

	/**
	 * Return x-coordinate of this point object.
	 * @return x-coordinate
	 */
	public double getX() {
		return x;
	}

	/**
	 * Set x-coordinate of this point object.
	 * @param x x-coordinate 
	 */
	public void setX(double x) {
		this.x = x;
	}

	/**
	 * Return y-coordinate of this point object.
	 * @return y-coordinate
	 */
	public double getY() {
		return y;
	}

	/**
	 * Set y-coordinate of this point object.
	 * @param y y-coordinate 
	 */
	public void setY(double y) {
		this.y = y;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return String.format("(%.2f,%.2f)", x, y );
	}
	
	public double distance( ) {
		double d = Math.sqrt(x*x + y*y);
		return d;
		
	}
	
	public int compareTo( Point p ) {
		if ( p.y < y) {
			return -10;
		}
		if (p.y > y ) {
			return 15;
		}
//		if ( p.x > x) {
//			return -10;
//		}
//		if (p.x < x  ) {
//			return 15;
//		}
		
		return 0;
	}

}
