package lecture10;

import java.io.FileNotFoundException;

/**
 * This class demonstrates how to use File and PrintWriter classes to write text
 * data to an output file.
 * 
 * @author Joanna Klukowska
 *
 */
public class WriteData {
	//If the file cannot be created the PrintWriter constructor throws
	//an exception. The program either has to catch it and handle it, or 
	//re-throw it (as it is done in this main()).
	public static void main(String[] args) throws FileNotFoundException  {
		
		//create a File object (this does not create a file on disk yet)
		java.io.File file = new java.io.File("scores.txt");  
		//if the file exists, warn the user and terminate the program
		//(this prevents from overwriting the existing data)
		if (file.exists()) {
			System.out.println("File already exists");
			System.exit(0); //this is optional, file could be overwritten instead 
		}

		//create a PrintWriter object (this creates the actual file on disk)
		//(if the file exists, it gets overwritten)
		java.io.PrintWriter output = new java.io.PrintWriter(file);

		//write formatted output to the file 
		output.print("John T Smith ");
		output.println(90);
		output.print("Eric K Jones ");
		output.println(85);
		output.print("Jessica A Bones ");
		output.println(65);
		output.print("Catherine P Doe ");
		output.println(99);
		output.print("Joanna L Klukowska ");
		output.println(50);

		// Close the file
		output.close();
	}
}
