package lecture10;

import java.io.FileNotFoundException;
import java.util.InputMismatchException;
import java.util.NoSuchElementException;
/**
 * This class demonstrates how to use File and Scanner classes to read text
 * data from an input file.
 * 
 * @author Joanna Klukowska
 *
 */
import java.util.Scanner;

public class ReadData {
	// If the file cannot be opened the Scanner constructor throws
	// an exception. The program either has to catch it and handle it, or
	// re-throw it (as it is done in this main()).
	public static void main(String[] args) throws FileNotFoundException {
		
		//create a File object (this can be done even if the file 
		//does not exist on disk)
		java.io.File file = new java.io.File("scores.txt");
		
		if (!file.exists()){
			System.err.println("No such file based on using File class.");
			System.exit(0);
		}
		
		
		//create a Scanner object for the file (this fails if the input
		//file does not exist on disk) 
		Scanner input = null;
		input = new Scanner(file);
			System.err.println("No such file.");
			System.exit(0);
		

		//read data from the input file (same methods as we used for reading
		//from the user) 
		while (input.hasNext()) {
			String firstName = input.next();
			String mi = input.next();
			String lastName = input.next();
			int score = input.nextInt();
			System.out.println(firstName + " " + mi + " " + lastName + " "
					+ score);
		}

		// Close the file
		input.close();
	}
}
