package lecture10;

import java.util.*;

/**
 * This program demonstrates how to catch exceptions when user does not enter
 * the appropriate type of data.
 * 
 * @author Joanna Klukowska
 *
 */
public class InputData {

	public static void main(String[] args) {
		
		Scanner in = new Scanner (System.in );
		
		int n;
		double f;
		String s;
		
		//When user is well-behaved, the program runs as normal.
		//When user is not behaving, the program throws an exception. Normally 
		//this leads to a crash, but the program can catch and handle this 
		//situation. 
		try {
			System.out.println("Enter an integer: ");
			n = in.nextInt();
			
			System.out.println("Enter a real number: ");
			f = in.nextDouble();
			
			System.out.println("Enter a string: ");
			s = in.next();
			
			System.out.println(" You entered: " + n + "  " + f + "   " + s);
			
			System.out.println( (int)f / n );
		}
		catch (InputMismatchException e ) {
			System.out.println("\nYou caused the following error:" + e );
			System.out.println("Follow instructions next time!");
		}
		catch (ArithmeticException e ) {
			System.out.println("\nNever divide by zero!");
		}
		
		System.out.println("\n\nAnd the program is allowed to continue ...\n");
		
		in.close();
		
	}

}
