package lecture09_processing;

import processing.core.PApplet;
import processing.core.PImage;

public class Race_02  extends PApplet {
	
	Turtle_02 myTurtle;
	Hare_02 myHare;
	//race can be in one of the following states:
	// 1 - not started
	// 2 - in progress
	// 3 - finished
	int stateOfTheRace = 1;
	String positionT, positionH;
	int counter=0;
	
	// runs one time
	public void setup() {
		// size the canvas
		size(900, 300);
		// create a ball - note that we are passing
		// a reference to this PApplet instance using
		// the "this" keyword
		this.myTurtle = new Turtle_02( this );
		this.myHare = new Hare_02( this );
		frameRate(10);
	}

	// infinite loop
	public void draw() {
		if ( stateOfTheRace == 1 ) //not started 
		{
			fill(0,0,0); 
			// erase background
			background(0, 128, 30);
			rect(100, 0, 2, 300);
			rect(800, 0, 2, 300);
			 
			textSize(11);
			textAlign(CENTER);
			text("FINISH\n"+" \n" + "LINE", 810, 50, 8, 200);
			
			image(myTurtle.getBefore(), 20, 80,  myTurtle.getBefore().width * 70 / myTurtle.getBefore().height, 70 );
			image(myHare.getBefore(), 20, 180, 70, myHare.getBefore().height * 70 / myHare.getBefore().width );
			
			textSize(30);
			fill(255,0,0);
			textAlign(CENTER);
			text("The contenders are ready!\nPress any key to start the race.", 450, 100);
			if ( keyPressed )
			{
				stateOfTheRace = 2;
			}
			
			
		}
		else if (stateOfTheRace == 2 ) //in progress 
		{
			fill(0,0,0);
			// erase background
			background(0, 128, 30);
			rect(100, 0, 2, 300);
			rect(800, 0, 2, 300);
			textSize(11);
			textAlign(CENTER);
			text("FINISH\n"+" \n" + "LINE", 810, 50, 8, 200);
			
			textSize(12);

			positionT = String.format("Cecil: %3d", myTurtle.getX()-100);
			positionH = String.format("BugsBunny: %3d", myHare.getX()-100);
			if (myTurtle.getX() > myHare.getX())
			{
				fill(255, 0, 0 );
				text( positionT, 400, 290);
				fill(0, 0, 0 );
				text( positionH, 500, 290);
			}
			else 
			{
				fill(0, 0, 0 );
				text( positionT, 400, 290);
				fill(255, 0, 0 );
				text( positionH, 500, 290);
			}
			

			this.myTurtle.move();
			this.myHare.move();
			
			if ( myTurtle.isFinished() || myHare.isFinished() ) {
				stateOfTheRace = 3;
			}
		}
		else { //race finished 
			// erase background
			counter++;
			if (counter == 5) {
				counter = 0;
				background(random(0,255), random(0,255), random(0,255) );
			}
									
			textSize(30);
			fill(0,0,0);
			textAlign(CENTER);
			if (myTurtle.isFinished()) {
				text("Turtle Won! "  , 450, 100); 
				image(myTurtle.getWon(), 412, 150 );
			}
			else{
				text("Hare Won! "  , 450, 100);
				image(myHare.getWon(), 400, 110, 100, myHare.getWon().height * 100 / myHare.getWon().width );
			}
		}
	}
}

class Turtle_02 {
	
	private int x = 100;
	private int y = 100;
	private int step = 0;
	private int increment;
	private int direction = +1;
	private boolean finished = false;
	private PImage turtle_won;
	private PImage turtle_before_start;

	PApplet canvas;
	
	public Turtle_02 ( PApplet canvas )
	{
		this.canvas = canvas; 
		turtle_won = this.canvas.loadImage("Cecil060.jpg");
		turtle_before_start = this.canvas.loadImage("CECIL.png");
	}
	
	public void move ( ) {
		
		if ( x >= 800 ) {
			x = 800;
			finished = true;
		}
		else if (step > 0){
			x = x + direction*increment;
			step--;
			if (x < 100) {
				x = 100;
			}
		}			
		else {
			int diceRoll = (int) (Math.random() * 100);
			if (diceRoll <= 40) {
				direction = 1;
				step = 10;
				increment = 3;
				}
			else if (diceRoll <= 60) {
				direction = -1;
				step = 10;
				increment = 2;
				}
			else if (diceRoll <= 90) {
				direction = 1;
				step = 10;
				increment = 1;
				}
			x = x + direction*increment;
			step--;
			if (x < 100) {
				x = 100;
			}
		}
		canvas.fill(140,92,14);
		canvas.arc(x, y, 30, 20, canvas.PI, canvas.TWO_PI);
		//canvas.ellipse(x, y, 15, 10);
	}
	public boolean isFinished () {
		return finished;
	}
	
	public PImage getWon()
	{
		return turtle_won;
	}
	
	public PImage getBefore()
	{
		return turtle_before_start;
	}
	
	public int getX()
	{
		return x;
	}
}

class Hare_02 {
	
	private int x = 100;
	private int y = 200;
	private int step = 0;
	private int increment;
	private int direction = +1;
	private boolean finished = false;
	private PImage bunny_won;
	private PImage bunny_before_start;

	PApplet canvas;
	
	public Hare_02 ( PApplet canvas )
	{
		this.canvas = canvas; 
		String url = "https://upload.wikimedia.org/wikipedia/en/2/26/Classic_bugsbunny.png";
		bunny_won = this.canvas.loadImage(url, "png");
		//bunny_won = this.canvas.loadImage("BugsBunny_rest.png");
		bunny_before_start = this.canvas.loadImage("BugsBunny_rest.png");
		
	}
	
	public void move ( ) {
		int y = this.y;
		if ( x >= 800 ) {
			x = 800;
			finished = true;
		}
		else if (step > 0){
			x = x + direction*increment;
			step--;
			if (x < 100) {
				x = 100;
			}
		}			
		else {
			
			int diceRoll = (int) (Math.random() * 100);
			if (diceRoll <= 20) {
				direction = 1;
				step = 10;
				increment = 9;
			}
			else if (diceRoll <= 30) {
				direction = -1;
				step = 10;
				increment = 12;
			}
			else if (diceRoll <= 60) {
				direction = 1;
				step = 10;
				increment = 4;
			}
			else if (diceRoll <= 80) {
				direction = -1;
				step = 10;
				increment = 2;
			}
			x = x + direction*increment;
			step--;
			if (x < 100) {
				x = 100;
			}
		}
		canvas.fill(100,100,100);
		canvas.triangle(x, y, x + 7, y + 30, x + 20, y + 30);
		canvas.triangle(x + 25, y, x + 7, y + 30, x + 20, y + 30);
		//canvas.rect(x, y, 5, 30);
	}
	

	public boolean isFinished () {
		return finished;
	}
	
	public PImage getWon()
	{
		return bunny_won;
	}
	
	public PImage getBefore()
	{
		return bunny_before_start;
	}

	
	public int getX()
	{
		return x;
	}
	
	
}