package lecture09_processing;

//package cs101_processing;

import processing.core.PApplet;

public class Race  extends PApplet {
	// instance vars
	Turtle myTurtle;
	Hare myHare;

	// runs one time
	public void setup() {
		// size the canvas
		size(900, 300);
		// create a ball - note that we are passing
		// a reference to this PApplet instance using
		// the "this" keyword
		this.myTurtle = new Turtle( this );
		this.myHare = new Hare( this );
		frameRate(10);
	}

	// infinite loop
	public void draw() {
		// erase background
		background(0, 128, 30);
		rect(100, 0, 2, 300);
		rect(800, 0, 2, 300);
		// tell the ball object to move
		this.myTurtle.move();
		this.myHare.move();
	}
}

class Turtle {
	
	private int x = 100;
	private int y = 100;

	PApplet canvas;
	
	public Turtle ( PApplet canvas )
	{
		this.canvas = canvas; 
	}
	
	public void move ( ) {
		
		if ( x >= 800 ) {
			x = 800;
		}
		else {
			int diceRoll = (int) (Math.random() * 100);
			if (diceRoll <= 40) {
				x += 30;
				}
			else if (diceRoll <= 60) {
				x -= 60;
				}
			else if (diceRoll <= 90) {
				x += 10; 
				}
			
			if (x < 100) {
				x = 100;
			}
		}
		canvas.ellipse(x, y, 15, 10);
	}
	
}

class Hare {
	
	private int x = 100;
	private int y = 200;

	PApplet canvas;
	
	public Hare ( PApplet canvas )
	{
		this.canvas = canvas; 
	}
	
	public void move ( ) {
		int y = this.y;
		if ( x >= 800 ) {
			x = 800;
		}
		else{
			
			int diceRoll = (int) (Math.random() * 100);
			if (diceRoll <= 20) {
				x += 90;
				}
			else if (diceRoll <= 30) {
				x -= 120;}
			else if (diceRoll <= 60) {
				x += 10; }
			else if (diceRoll <= 80) {
				x -= 20; }
			
			if (x < 100) {
				x = 100;
			}
		}
		canvas.rect(x, y, 5, 30);
	}
	
}
