/**
 * Test program #11: Using objects
 *  
 * @author:      Joanna Klukowska
 * @since:       Nov. 4, 2013
 * 
 * Objects that need to draw themselves on the canvas, 
 * need to be given direct access to the canvas. The Disk class
 * has its own data field of type PApplet that is initialized to 
 * the canvas used by the current application in the constructor
 * call. This way each disk object can draw itself onto the common
 * canvas.  
 * 
 *  For more details see http://processing.org/reference/ 
 */
package lecture09_processing;

import processing.core.PApplet;

public class ProcessingExample12 extends PApplet 

{	
	//dimensions of the canvas
		int xMax = 600;
		int yMax = 400;
		
		
		int totalNumOfDisks = 100;
		Disk2 [] myDisks = new Disk2[totalNumOfDisks] ;
		
		int numOfIterations = 0;
		
		public void setup() 
		{
			size(xMax,yMax);

			for (int i = 0; i < myDisks.length; i++) 
				myDisks[i] = new Disk2(this);
						
		}
		
		public void draw()
		{
			numOfIterations++;
			if (numOfIterations > 5) {
				numOfIterations=0;

				for (int i = 0; i < myDisks.length; i++) 
					myDisks[i].move();
			}
				
			
			background (0,0,0);
			for (int i = 0; i < myDisks.length; i++) 
				myDisks[i].change();
						
		
		}
		
}

