/**
 * Test program #11: Using objects
 *  
 * @author:      Joanna Klukowska
 * @since:       Nov. 4, 2013
 * 
 * Objects that need to draw themselves on the canvas, 
 * need to be given direct access to the canvas. The Disk class
 * has its own data field of type PApplet that is initialized to 
 * the canvas used by the current application in the constructor
 * call. This way each disk object can draw itself onto the common
 * canvas.  
 * 
 *  For more details see http://processing.org/reference/ 
 */
package lecture09_processing;

import processing.core.PApplet;

public class ProcessingExample11 extends PApplet 
{	
	//dimensions of the canvas
		int xMax = 600;
		int yMax = 400;
		int maxDisks = 15;
		Disk [] myDisks = new Disk[maxDisks];
		int currentNumOfDisks = 1;
		
		
		int counter = 0;
		
		
		
		public void setup() 
		{
			size(xMax,yMax);
			
			//create all the disks once
			for (int i = 0; i < myDisks.length; i++)
				myDisks[i] = new Disk(this);
						
		}
		
		public void draw()
		{
			//redraw the background
			background (188, 188, 188);
			
			counter++;
			if (counter >= 50  && currentNumOfDisks < maxDisks) {
				currentNumOfDisks++;
				counter = 0;
			}
				
			
			//let the disks move according to their own rules
			for (int i = 0; i < currentNumOfDisks; i++)
				myDisks[i].move();
		}
		
}