package lecture09_processing;

import processing.core.PApplet;

class Disk {
	protected float x;
	protected float y;
	protected float rx;
	protected float ry;
	
	protected float xSpeed;
	protected float ySpeed;
	
	PApplet canvas;

	protected int col;
	protected float red=0, green=0, blue=0, alpha=0;
	protected int numOfMoves = 0;
	
	private static int numOfDisks = 0;
	
	public Disk ( PApplet canvas )
	{
		this.canvas = canvas;
		x = canvas.random(0,  canvas.width); 
		y = canvas.random(0, canvas.height);
		rx = canvas.random(15, 35 );
		ry = canvas.random(15, 35 );
		xSpeed = canvas.random(-5, 5 );
		ySpeed = canvas.random(-5, 5 );

		numOfDisks++;
		
		if (numOfDisks%4 == 0) {
			red = 255; 
			blue = 100;
		}
		else if (numOfDisks%4 == 1)  {
			red = 255; 
			blue = 100;
			green = 255;
		}
		else if (numOfDisks%4 == 2)  {
			blue = 100;
			green = 255;
		}
		else if (numOfDisks%4 == 3)  {
			blue = 255;
			red = 150;
		}
		
		alpha = 255;
		col = canvas.color(red, green, blue, alpha);
		
	}
	
	public void move() {
		// update position based on speed
		x += xSpeed;
		y += ySpeed;
		// bouncing logic - see if the ball hits any of the edges
		// note how we are referring to the width and height
		// instance vars on the PApplet object

		if (x > canvas.width) {
			x = canvas.width;
			xSpeed *= -1;
			changeShape ();
		}
		if (x < 0) {
			x = 0;
			xSpeed *= -1;
			changeShape ();
		}
		if (y > canvas.height) {
			y = canvas.height;
			ySpeed *= -1;
			changeShape ();
		}
		if (y < 0) {
			y = 0;
			ySpeed *= -1;
			changeShape ();
		}
		//adjust the color settings
		numOfMoves++;
		if (numOfMoves > 2 && alpha > 0) {
			alpha--;
			numOfMoves = 0;
		}
		col = canvas.color(red, green, blue, alpha);
		canvas.fill(col);
		canvas.stroke(col);
		// call the ellipse method on the PApplet object to draw
		// this object to the canvas
		this.canvas.ellipse(x, y, rx, ry);
	}
	
	protected void changeShape () {

		float tmp = rx;
		rx = ry;
		ry = tmp;
	}
	
}