package lecture09;

import java.util.Random;

/**
 * This class represents a snail racer. The class inherits all the methods provided
 * by the Animal class but overwrites the move() method with a method specific 
 * to the snails. 
 * Objects of this class are participants in a running race. 
 * 
 * @author Joanna Klukowska
 */
public class Snail extends Animal {
	//random number generator 
		private static Random rand = new Random();
			
		/**
		 * Creates a Hare-racer with specified shirt number. 
		 * @param number
		 */
		public Snail(String number) {
			super(number);
		}
		

		/**
		 * Creates a Snail-racer with specified shirt number. 
		 * @param number
		 */
		@Override
		public void move () {
			int whichMove = rand.nextInt(10);
			switch (whichMove) {
			case 0: 
			case 1: 
			case 2: position = position + 5;   //30% long slide: +5
	                break;
			case 3: 
			case 4:
			case 5: 
			case 6: 
			case 7: position = position + 2;    //50% short slide:  +2
	                break;
			case 8: position = position - 8;    //10% slips back: -8 
			        break;
			case 9: position = position + 0;	//10% no change
			
			}
		}
}
