package lecture09;

import java.util.Random;


/**
 * This class represents a hare racer. The class inherits all the methods provided
 * by the Animal class but overwrites the move() method with a method specific 
 * to the hares. 
 * Objects of this class are participants in a running race. 
 * 
 * @author Joanna Klukowska
 */
public class Hare extends Animal {

	//random number generator 
	private static Random rand = new Random();
	
	/**
	 * Creates a Hare-racer with specified shirt number. 
	 * @param number
	 */
	public Hare(String number) {
		super(number);
	}
	
	/* (non-Javadoc)
	 * @see lecture01.RaceContender02#move()
	 */
	@Override
	public void move () {
		int whichMove = rand.nextInt(10);
		switch (whichMove) {
		case 0: 
		case 1: position = position + 10;   //20% large hop: +10
                break;
		case 2: 
		case 3: 
		case 4:
		case 5: position = position + 3;    //40% small hop:  +3
                break;
		case 6: 
		case 7: position = position - 8;    //20% slips back: -8 
		        break;
		case 8:
		case 9: position = position + 0;	//20% no change
		
		}
	}

}
