package lecture09;

import java.util.Random;

/**
 * This class represents a duck racer. The class inherits all the methods provided
 * by the Animal class but overwrites the move() method with a method specific 
 * to the ducks. 
 * Objects of this class are participants in a running race. 
 * 
 * @author Joanna Klukowska
 */
public class Duck extends Animal {
	
	//random number generator 
	private static Random rand = new Random();
		
	/**
	 * Creates a Duck-racer with specified shirt number. 
	 * @param number
	 */
	public Duck(String number) {
		super(number);
	}
	
	/* (non-Javadoc)
	 * @see lecture01.RaceContender02#move()
	 */
	@Override
	public void move () {
		int whichMove = rand.nextInt(10);
		switch (whichMove) {
		case 0: 
		case 1: 
		case 2: position = position + 7;    //30% short flight: +7
            break;
		case 3: 
		case 4:
		case 5: 
		case 6: position = position + 2;    //40% duck walk:  +2
                break;
		case 7: position = position - 12;    //10% slips back: -2
		        break;
		case 8:
		case 9: position = position + 0;	//20% no change
		
		}
	}

}
