package lecture09;

import java.util.Random;

import processing.core.PApplet;


/**
 * This class represents an animal racer.
 * Objects of this class are participants in a running race. Those objects move 
 * at random increments.
 * 
 * @author Joanna Klukowska
 *
 */
public class Animal{
	//position along the race track
	protected int position;
	//shirt number of the animal-racer
	protected String number;
	
	//random number generator 
	private static Random rand = new Random();
	//size of the largest allowed move 
	public static final int LARGEST_MOVE = 1;
	
	/**
	 * Creates a new object with specified shirt number. 
	 * @param number
	 *   number on the "shirt" of the animal
	 */
	public Animal(String number) {
		this.number = number;
		position = 0;
	}
	
	/**
	 * Moves the current object by updating the current position by a random
	 * number from 0 to LARGEST_MOVE.
	 */
	 public void move( ) {
		 //move by a random positive number between 1 and LARGEST_MOVE
		position = position + rand.nextInt(LARGEST_MOVE)+1;
	}

	/**
	 * Returns the shirt number of this object.
	 * @return the number
	 */
	public String getNumber() {
		return number;
	}

	/**
	 * Returns the position of this object.
	 * @return the position
	 */
	public int getPosition() {
		return position;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return number;
	}
	
	/**
	 * Returns a string containing information about this object. 
	 * @return the name of the class concatenated with the shirt number. 
	 */
	public String getInfo () {
		return this.getClass().getSimpleName() + " " + number;
	}
	
	

	
	
	
}

