/**
 * 
 */
package lecture07;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Scanner;
import java.util.regex.Pattern;

import processing.core.PApplet;
import processing.core.PFont;

/**
 * 
 * @author Joanna Klukowska
 * @version Jan 17, 2014 
 *
 */
@SuppressWarnings("serial")
public class StockQuoteApp extends PApplet {
	
	String stockSymbol = "";
	boolean keyRead = false;
	PFont f;			// font to be used for display (monospace prevents 
    // the display from shifting as the characters are added) 
	
	public void setup() {
		size(700,300);
		f = createFont("FreeMono Bold",60);
		textFont(f);

		
		background (128,128,128);
		textAlign(LEFT);
		textSize(20);
		fill(0, 0, 0);
		text("Enter a stock symbol and press Enter: ",30,30);
		
		
	}
	
	public void draw()
	{
		
		
		//when DELETE key is pressed, redraw the screen and 
		//wait for the new stock symbol
		if ( keyPressed && (key == DELETE) ) {
			background (128,128,128);
			textAlign(LEFT);
			textSize(20);
			fill(0, 0, 0);
			text("Enter a stock symbol and press Enter: ",30,30);
		
		}
		//when ENTER key is pressed, check the string stored as 
		//as the stock symbol and display data
		if ( keyPressed && (key == ENTER | key == RETURN) && stockSymbol != "") {
				
			//get the source code (HTML code) of the page we want to parse
			String pageCode = getStringFromWeb ("http://finance.yahoo.com/q?s=" + stockSymbol);
			//System.out.println(pageCode);
			
			String display = "";
			String name = getStockName( pageCode );
			if ( pageCode == null | name.length() == 0 ) {
				display = String.format("Cannot find symbol: %s", stockSymbol);
			}
			else {
				double change = Double.valueOf(getStockPriceChange( pageCode));
				char arrow = '\0';
				if (Double.valueOf(change) > 0) {
					
					fill(0,255,0);
					arrow = '\u2191';
				}
				else {
					fill(255, 0,0);
					arrow = '\u2193';
				}
				display += "SYMBOL:         " + stockSymbol;
				display += "\nNAME:           " +  name;
				display += "\nPRICE:          " + getStockPrice( pageCode ) + "   " + arrow;
				display += "\nTIME RETRIEVED: " + getStockPriceTime(pageCode );
				display += "\n";
			}
			textAlign(LEFT);
			textSize(20);
			//fill(149,255,0);
			
			text(display,50,100);
			

			textAlign(LEFT);
			textSize(14);
			fill(0,0,0);
			
			text("Pres DEL key to enter new symbol. ",30,260);
			
			stockSymbol = "";
		}
		
		//read and accumulate letters until the ENTER key is pressed,
		//set variable keyRead until the particular key is released
		//to prevent multiple reads of the same letter
		if ( keyPressed && Character.isLetter(key) && !keyRead ) {
			key = Character.toUpperCase(key);
			stockSymbol = stockSymbol + key;
			keyRead = true;
			
			textAlign(LEFT);
			textSize(25);
			fill(0, 0, 255);
			text(stockSymbol,500,30);
		}
		

		

	}
	

	
	public void keyReleased() {
		keyRead = false;
	}
	
	
	/**
	 * Determines the name of the stock given the HTML source code
	 * of a Yahoo Finance webpage with stock info. 
	 * @param pageCode
	 *   string containing HTML source code
	 * @return
	 *   string containing the name of the stock
	 */
	public static String getStockName(String pageCode) {
		/* The page source code contains a line near the top of the page
		 * that includes both the stock symbol and stock name in a single line 
		 * enclosed by <title> ... </title> tags. For example: 
		 *   <title>NFLX: Summary for Netflix, Inc.- Yahoo! Finance</title>
		 * Everything, except for the symbol and name of the stock is fixed. 
		 * We use that to parse the line to extract its name given the symbol. 
		 */
		//find the first occurrence of <title> tag
		int p = pageCode.indexOf("<title>", 0);
		//find the first substring "Summary for" that comes after position p
		int from = pageCode.indexOf("Summary for ", p);
		//find the location of the substring "- Yahoo! Finance"
		int to = pageCode.indexOf("- Yahoo! Finance", from);
		//the name of the stock is a substring between the end of substring from 
		//and position to
		String name = pageCode.substring(from + "Summary for ".length(), to);
		
		return name;

	}
	
	/**
	 * Determines the price of the stock given the HTML source code
	 * of a Yahoo Finance webpage with stock info. 
	 * @param pageCode
	 *   string containing HTML source code
	 * @return
	 *   string containing the price of the stock
	 */
	public static String getStockPrice(String pageCode) {
		/* The price of the stock is located on the line that contains a 
		 * substring that looks something like this:
		 *   <span id="yfs_l84_nflx">338.18</span>
		 */ 
		//find location of substring "yfs_l84"
		int p = pageCode.indexOf("yfs_l84", 0);
		//find the first closing angle bracket after position p
		int from = pageCode.indexOf(">", p);
		//find the next occurrence of closing </span> tag
		int to = pageCode.indexOf("</span>", from);
		//the price of the stock should be between from and to positions
		String price = pageCode.substring(from+1, to);
		
		return "$"+price;
	}
	
	/**
	 * Determines the time at which the price of the stock was last updated 
	 * given the HTML source code of a Yahoo Finance webpage with stock info. 
	 * @param pageCode
	 *   string containing HTML source code
	 * @return
	 *   string containing the time of last price of the stock update
	 */
	
	public static String getStockPriceTime(String pageCode) {
		/* The time of last stock price update is located on the line that contains a 
		 * substring that looks something like this:
		 *   <span id="yfs_market_time">Tue, Jan 14, 2014, 2:50PM EST - U.S. Markets close in 1 hr 10 mins</span>
		 */ 
		//find location of substring "<span id="yfs_market_time">"
		int p = pageCode.indexOf("<span id=\"yfs_market_time\">", 0);
		//find the first closing angle bracket after position p
		int from = pageCode.indexOf(">", p);
		//find the next occurrence of substring "- U.S. "
		int to = pageCode.indexOf("- U.S. ", from);
		//the date and time of the stock price update should be between from and to positions
		String time = pageCode.substring(from+1, to);
		
		return time;

	}
	
	/**
	 * Determines the most recent price change of the stock  
	 * given the HTML source code of a Yahoo Finance webpage with stock info. 
	 * @param pageCode
	 *   string containing HTML source code
	 * @return
	 *   string containing the time of last price of the stock update
	 */
	public static String getStockPriceChange ( String pageCode ) {
		
		/* The time of last stock price update is located on the line that contains a 
		 * substring that looks something like this:
		 *   <span id="yfs_c63_nflx"><img ... src="... " class="pos_arrow" alt="Up">   1.37</span>
		 * or 
		 *   <span id="yfs_c63_nflx"><img ... src="... " class="neg_arrow" alt="Down">   1.37</span>
		 * The up or down change can be determined using the word that comes after alt. 
		 */ 
		//find location of substring "yfs_c63"
		int p = pageCode.indexOf("yfs_c63", 0);
		//find the first location of substring "alt=" after position p
		p = pageCode.indexOf("alt=", p);
		//find the first closing angle bracket after position p
		int from = pageCode.indexOf(">", p);
		//find the next occurrence of substring "</span>"
		int to = pageCode.indexOf("</span>", from);
		//the date and time of the stock price update should be between from and to positions
		//the sign is determined by letter at position p + 5
		String priceChange;
		if (pageCode.charAt(p+5) == 'D' )
			 priceChange = "-" + pageCode.substring(from+1, to).trim();
		else 
			 priceChange = "+" + pageCode.substring(from+1, to).trim();
		
		return priceChange;
		
	}
	
	
	/**
	 * The method obtains HTML source code of the webpage given
	 * by the parameter.
	 * @param stringURL
	 *    URL of a webpage 
	 * @return
	 *    string containing the entire HTML source code of the webpage at
	 *    URL specified by the parameter
	 *    or a null string if errors occurred
	 */
	public static String getStringFromWeb (String stringURL )
	{
	    // assume Unicode UTF-8 encoding
	    final String CHARSET_NAME = "UTF-8";	    
	    final Pattern EVERYTHING_PATTERN  = Pattern.compile("\\A");
	    URL url = null;	    
		Scanner scanner = null;		
		String result = "";
		
		try {
			//create an url object and connect to the site
            url = new URL(stringURL);
			URLConnection site = url.openConnection();
			//use the source code as in input stream and read in the entire website
			InputStream is = site.getInputStream();
			scanner = new Scanner(new BufferedInputStream(is), CHARSET_NAME);
			if (scanner.hasNextLine())
	            result = scanner.useDelimiter(EVERYTHING_PATTERN).next();
		
			scanner.close();
        
		} catch (IOException ioe) {
			//if there are errors connecting or reading the site, print an error message
			System.err.println("Could not open " + url);
		}
        return result;
	}
	

}
