package lecture07;


public class Stock {
  private String symbol;
  private String name;
  private double previousClosingPrice;
  private double currentPrice;

  public Stock() {
  }

  public Stock(String newSymbol, String newName) {
    symbol = newSymbol;
    name = newName;
  }


  public Stock(String symbol, String name, double currentPrice) {
    this.symbol = symbol;
    this.name = name;
    this.currentPrice = currentPrice;
  }

  public double getChangePercent() {
    return (currentPrice - previousClosingPrice) /
      previousClosingPrice;
  }
  
  public double getPreviousClosingPrice() {
    return previousClosingPrice;
  }
  
  public double getCurrentPrice() {
    return currentPrice;
  }
  
  public void setCurrentPrice(double newCurrentPrice) {
    currentPrice = newCurrentPrice;
  }
  
  public void changeName(String symbol, String name) {
    this.symbol = symbol;
    this.name = name; 
  }
  
  public void setPreviousClosingPrice(
                    double newPreviousClosingPrice) {
    previousClosingPrice = newPreviousClosingPrice;
  }
  
  public String toString ( ) {
	  return String.format("%5s (%s), $%.2f" , symbol, name, currentPrice );
  }
  
  
  public boolean equals ( Stock other ){ 
	  if ( this.symbol.equals(other.symbol) && 
			  this.name.equalsIgnoreCase(other.name) )
		  return true;
	  return false;
  }
  
  
  
  
  
  
}

