package lecture06;

 import java.util.Comparator;
import java.util.Random;

/**
 * SortingCircles class
 * 
 * Test program for Circle object. It demonstrates sorting arrays
 * of circles. 
 * 
 * @author     Joanna Klukowska (
 * @since      Oct. 21, 2013
 * 
 */
 
 public class SortingCircles {
	 /** 
	  * Generate sevaral random circles, 
	  * store them in an array and then sort the array.
	  */
	 public static void main( String [] args ) {
		
		int i;	//loop counter
		double tmpRadius;
		//create Random object
		Random rand = new Random();
		
		//create an array of Circle objects
		Circle [] listOfCircles = new Circle [10];
		
		//NOTE: we did not create any circles yet
		System.out.printf("After creating the array, the number of Circle objects is %d\n", 
		                   Circle.getNumberOfObjects() );
		
		//Create ten random Circle objects one for each array entry
		for (i = 0; i < listOfCircles.length; i++ )
		{
			tmpRadius = rand.nextDouble() * 100;
			listOfCircles[i] = new Circle( tmpRadius,
			                rand.nextInt()%100,
			                rand.nextInt()%100 );
		}
		
		//Now, there should be 10 circles
		System.out.printf("After filling the array, the number of Circle objects is %d\n", 
		                   Circle.getNumberOfObjects() );
		
		//Show the list of circles array
		System.out.printf("\n\nUnsorted: \n");
		for (i = 0; i < listOfCircles.length; i++ )
		{
			System.out.println( listOfCircles[i] );
		}
		
		//Sort the list of Circle objects according to the radius
		sortCircles( listOfCircles );
		
		////Show the list of circles array
		System.out.printf("\n\nSorted: \n");
		for (i = 0; i < listOfCircles.length; i++ )
		{
			System.out.printf("%s\n", listOfCircles[i] );
		}
		
	 } 
	 /**
	  * Sort the array of Circles. 
	  * The list array contains Circle objects sorted
	  * from the smallest to largest radius.
	  * 
	  * THIS METHOD DOES NOT WORK CORRECTLY!
	  * 
	  * @param list the array of Circle objects
	  * 
	  */  
	public static void sortCircles_take2( Circle [] list ) 
	{
		//WRITE THIS CODE BASED ON THE selectionSort method below
		for (int i = 0; i < list.length - 1; i++) {
			// Find the minimum in the list[i..list.length-1]
			double currentMin = list[i].getRadius();
			int currentMinIndex = i;
			for (int j = i + 1; j < list.length; j++) {
				if (currentMin > list[j].getRadius()) {
					currentMin = list[j].getRadius();
					currentMinIndex = j;
				}
			}

			// Swap list[i] with list[currentMinIndex] if necessary;
			if (currentMinIndex != i) {
				Circle tmp = list[i]; 
				list[i] = list[currentMinIndex];
				list[currentMinIndex] = tmp;
			}
		}
		
	} 
	 
	 
	 /**
	  * Sort the array of Circles. 
	  * The list array contains Circle objects sorted
	  * from the smallest to largest radius.
	  * 
	  * THIS METHOD DOES NOT WORK CORRECTLY!
	  * 
	  * @param list the array of Circle objects
	  * 
	  */  
	public static void sortCircles_take1( Circle [] list ) 
	{
		//WRITE THIS CODE BASED ON THE selectionSort method below
		for (int i = 0; i < list.length - 1; i++) {
			// Find the minimum in the list[i..list.length-1]
			double currentMin = list[i].getRadius();
			int currentMinIndex = i;
			for (int j = i + 1; j < list.length; j++) {
				if (currentMin > list[j].getRadius()) {
					currentMin = list[j].getRadius();
					currentMinIndex = j;
				}
			}

			// Swap list[i] with list[currentMinIndex] if necessary;
			if (currentMinIndex != i) {
				list[currentMinIndex].setRadius(list[i].getRadius());
				list[i].setRadius( currentMin);
			}
		}
		
	} 
	

	/**
	 * This method sorts an array passed to it as a parameter.
	 * This method modifies the array passed as the parameter. 
	 * @param list
	 *    array to be sorted 
	 */
	public static void selectionSort(double[] list) {
		
		for (int i = 0; i < list.length - 1; i++) {
			// Find the minimum in the list[i..list.length-1]
			double currentMin = list[i];
			int currentMinIndex = i;
			for (int j = i + 1; j < list.length; j++) {
				if (currentMin > list[j]) {
					currentMin = list[j];
					currentMinIndex = j;
				}
			}
			// Swap list[i] with list[currentMinIndex] if necessary;
			if (currentMinIndex != i) {
				list[currentMinIndex] = list[i];
				list[i] = currentMin;
			}
		}
	}
	
	
	
	 
	 
	 /**
	  * Sort the array of Circles. 
	  * The list array contains Circle objects sorted
	  * from the smallest to largest radius.
	  * 
	  * @param list the array of Circle objects
	  * 
	  */  
	public static void sortCircles( Circle [] list ) 
	{
		for (int i = 0; i < list.length - 1; i++) {
			// Find the minimum in the list[i..list.length-1]
			Circle currentMin = list[i];
			int currentMinIndex = i;
			for (int j = i + 1; j < list.length; j++) {
				if (currentMin.getRadius() > list[j].getRadius()) {
					currentMin = list[j];
					currentMinIndex = j;
				}
			}

			// Swap list[i] with list[currentMinIndex] if necessary;
			if (currentMinIndex != i) {
				list[currentMinIndex] = list[i];
				list[i] = currentMin ;
			}
		}
		
	} 


	public static void sortCircles( Circle [] list , Comparator<Circle> comp) 
	{
		for (int i = 0; i < list.length - 1; i++) {
			// Find the minimum in the list[i..list.length-1]
			Circle currentMin = list[i];
			int currentMinIndex = i;
			for (int j = i + 1; j < list.length; j++) {
				if (comp.compare(currentMin, list[j])   > 0 ) {
					currentMin = list[j];
					currentMinIndex = j;
				}
			}

			// Swap list[i] with list[currentMinIndex] if necessary;
			if (currentMinIndex != i) {
				list[currentMinIndex] = list[i];
				list[i] = currentMin ;
			}
		}
		
	} 
	
 } 
		 
