package lecture06;

/**
 * A class that represent simple circles in 2D by using
 * their radius. 
 * 
 * @author Joanna Klukowska 
 *
 */
public class SimpleCircle {
	
	private double radius;

	/**
	 * Default constructor that creates a circle of radius 1. 
	 */
	SimpleCircle() {
		radius = 1;
	}

	/**
	 * Creates a circle with a given radius, 
	 * or radius=1 if provided radius is negative.
	 * @param newRadius  radius for the new circle 
	 */
	SimpleCircle(double newRadius) {
		setRadius(newRadius);
	}

	double getArea() {
		return radius * radius * Math.PI;
	}

	public double getPerimeter() {
		return 2 * radius * Math.PI;
	}

	void setRadius(double newRadius) {
		if ( newRadius < 0) {
			radius =1;
		}
		else {
			radius = newRadius;
		}
	}

	double getRadius( ) {
		return radius;
	}
}