package lecture06;


/**
 * This program compares increment methods with various parameters.
 * 
 * @author     Joanna Klukowska 
 * @version	   Oct. 30, 2013
 */

 
 public class IncrementExample {
     public static void main ( String [] args )
     {
         int myNumber = 1;
         Square mySquare = new Square(1);
         MyInteger myOwnInteger = new MyInteger(1); 
         
         System.out.println("\nBefore the loop: " ); 
         System.out.printf("%-20s %3d\n", "myNumber  is:", myNumber );
         System.out.printf("%-20s %3.0f\n", "side of mySquare  is", mySquare.getSide() );
         System.out.printf("%-20s %3d\n", "myOwnNumber  is", myOwnInteger.get() );
         
         
         for (int i = 0; i < 5; i++ )
         {
             incrementInt( myNumber );
             incrementSquare ( mySquare );
             incrementInteger( myOwnInteger);
             
         }
         
         System.out.println("\nAfter the loop: " ); 
         System.out.printf("%-20s %3d\n", "myNumber  is:", myNumber );
         System.out.printf("%-20s %3.0f\n", "side of mySquare  is", mySquare.getSide() );
         System.out.printf("%-20s %3d\n", "myOwnNumber  is", myOwnInteger.get() );
         
         
     }  //end of main()
     
     public static void incrementInt( int number )
     {
         number = number + 1;
     }     
     
     public static void incrementInteger( MyInteger number )
     {
         number.increment();
     }
     
     public static void incrementSquare ( Square sq )
     {
         sq.setSide ( sq.getSide() + 1);
     }
 }
 
 class Square {
     
     private double side;
     
     public Square() {
         side = 0;
     }
     
     public Square( double s ) {
         setSide ( s );
     }
     
     public void setSide ( double s ) {
         if (s > 0 )
            side = s;
    }
    
    public double getSide () {
        return side;
    }
    
    public double getArea () {
        return side * side;
    }
    
    public double getPerimeter () {
        return 4 * side;
    }
 
}

class MyInteger {
    private int number;
    
    public MyInteger ( int n) { 
		number = n;
	}
	
	public void set ( int n ) {
		number = n;
	}
	
	public int get () {
		return number;
	}
	
	public int increment() {
		return ++number;
	}
	
	public int decrement() {
		return --number;
	}
	
}
	
	
