package lecture06;

import processing.core.PApplet;

@SuppressWarnings("serial")
public class DrawCircles extends PApplet {

	
	public void setup() {
		size( 500, 450 );
		//frameRate(2);
		
		textSize(18);
		fill(0,0,0);
		textAlign(CENTER);
	}
	
	public void draw() {
		//generate the color for the next circle
		fill(random(255), random(255), random(255));
		//create a new circle object
		CircleWithStaticMembers c = new CircleWithStaticMembers((int)(Math.random()*50));
		//draw c object on the canvas 
		this.ellipse((float)c.getX(), (float)c.getY(), 
				(float)c.getRadius(), (float)c.getRadius());
		
		//print the information about number of circles and total area to the console
		System.out.printf("There are %3d circles with total area of %10f.\n", 
				CircleWithStaticMembers.getNumberOfObjects(),
				CircleWithStaticMembers.getTotalArea()) ;
		
		//repaint the background for text information before updated info is printed
		fill(0,0,0);
		rect(0, 400, 500, 50);
		//print the information about number of circles and total area to the canvas
		fill(255,255,255);
		text(String.format("There are %3d circles with total area of %10.2f.\n", 
				CircleWithStaticMembers.getNumberOfObjects(),
				CircleWithStaticMembers.getTotalArea()) , 250, 425 );
	}
	
}
