package lecture06;

public class CircleWithStaticMembers {

	private double radius;
	private int x;
	private int y;

	private static int numberOfObjects = 0;
	private static double totalAreaOfObjects = 0.0;

	public CircleWithStaticMembers() {
		radius = 10.0;
		x = (int) (Math.random() * 500);
		y = (int) (Math.random() * 400);
		numberOfObjects++;
		totalAreaOfObjects += getArea();
	}

	public CircleWithStaticMembers(double newRadius) {
		if (newRadius >= 0)
			radius = newRadius;
		else
			radius = 1.0;
		x = (int) (Math.random() * 500);
		y = (int) (Math.random() * 400);
		numberOfObjects++;
		totalAreaOfObjects += getArea();
	}

	public double getArea() {
		return radius * radius * Math.PI;
	}

	public void setRadius(double newRadius) {
		if (newRadius >= 0)
			radius = newRadius;
	}

	public double getRadius() {
		return radius;
	}
	
	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}

	public static int getNumberOfObjects() {
		return numberOfObjects;
	}

	public static double getTotalArea() {
		return totalAreaOfObjects;
	}

}
