package lecture06;

import java.util.Comparator;


/**
 * Circle class.
 * This class represents a circle.
 * @author Joanna Klukowska (based on source code in Chapter 8 of Liang).
 * @since Oct. 21, 2013
 * 
 */

public class Circle {
	/** the radius of this circle */
	private double radius;
	/** the x coordinate of the center of this circle */ 
	private int x;
	/** the y coordinate of the center of this circle */ 
	private int y;

	/**
	 * @return the value of x coordinate 
	 */
	public int getX() {
		return x;
	}

	/**
	 * @param x new value for x coordinate 
	 */
	public void setX(int x) {
		this.x = x;
	}

	/**
	 * @return the value of y coordinate
	 */
	public int getY() {
		return y;
	}

	/**
	 * @param y  new value for y coordinate
	 */
	public void setY(int y) {
		this.y = y;
	}

	/** The number of the objects created */
	private static int numberOfObjects = 0;

	/** Construct a circle with radius 1 */
	public Circle() {
		radius = 1;
		numberOfObjects++;

	}

	/**
	 * Construct a circle with a specified radius
	 * 
	 * @param newRadius
	 *            radius for the new circle
	 */
	public Circle(double newRadius, int newX, int newY) {
		if (newRadius < 0)
			radius = 1;
		else
			radius = newRadius;

		x = newX;
		y = newY;
		numberOfObjects++;
	}

	/**
	 * Accessor method.
	 * 
	 * @return radius
	 */
	public double getRadius() {
		return radius;
	}

	/**
	 * Mutator method: modifies the radius.
	 * 
	 * @param newRadius
	 *            new value for the radius
	 */
	public void setRadius(double newRadius) {
		// radius = (newRadius >= 0) ? newRadius : 1;
		if (newRadius >= 0)
			radius = newRadius;
		else
			radius = 0;
	}

	/**
	 * Return numberOfObjects
	 * 
	 * @return number of circle objects created
	 */
	public static int getNumberOfObjects() {
		return numberOfObjects;
	}

	/**
	 * Compute the area of this circle
	 * 
	 * @return area of the circle
	 */
	public double getArea() {
		return radius * radius * Math.PI;
	}

	/**
	 * Produce String objects that describes the circle
	 * 
	 * @return String object containing the radius
	 */
	public String toString() {
		return String.format("r = %7.2f, x = %3d, y = %3d", radius, x, y);
	}

}


class ComparatorByRadius implements Comparator<Circle>{
	
	public int compare(Circle arg0, Circle arg1) { 

		if (arg0.getRadius() == arg1.getRadius())
			return 0;
		else if (arg0.getRadius() > arg1.getRadius())
			return 1;
		else
			return -1; 
	}	
}
