package lecture05;

public class SortAlgorithms {


	public static void main(String[] args) {
		int i; // loop counter
		int size = 5;
		// generate a random array of real numbers
		double[] numbers = new double[size];
		for (i = 0; i < numbers.length; i++) {
			numbers[i] = Math.random() * 2 ;
		}

		// make two copies of the array
		double[] numbers2 = new double[size];
		double[] numbers3 = new double[size];
		for (i = 0; i < numbers.length; i++) {
			numbers2[i] = numbers[i];
			numbers3[i] = numbers[i];
		}
		

		printArray(numbers); 
		// sort the three arrays using three different methods
		
		bubbleSort(numbers3);
		
		
		insertionSort(numbers2);
		
		selectionSort(numbers);
		
		
		printArray(numbers); 
		
	}

	/**
	 * Sorts the given array using selection sort algorithm.
	 * @param list array to sort.
	 */
	public static void selectionSort(double[] list) {
		for (int i = 0; i < list.length - 1; i++) {
			// Find the minimum in the list[i..list.length-1]
			double currentMin = list[i];
			int currentMinIndex = i;

			for (int j = i + 1; j < list.length; j++) {
				if (currentMin > list[j]) {
					currentMin = list[j];
					currentMinIndex = j;
				}
			}

			// Swap list[i] with list[currentMinIndex] if necessary;
			if (currentMinIndex != i) {
				list[currentMinIndex] = list[i];
				list[i] = currentMin;
			}
		}
	}

	/**
	 * Sorts the given array using insertion sort algorithm.
	 * @param list array to sort.
	 */
	public static void insertionSort(double[] list) {
		for (int i = 1; i < list.length; i++) {
			/*
			 * insert list[i] into a sorted sublist list[0..i-1] so that
			 * list[0..i] is sorted.
			 */
			double currentElement = list[i];
			int k;
			for (k = i - 1; k >= 0 && list[k] > currentElement; k--) {
				list[k + 1] = list[k];
			}

			// Insert the current element into list[k+1]
			list[k + 1] = currentElement;
		}
	}

	/**
	 * Sorts the given array using bubble sort algorithm.
	 * @param list array to sort.
	 */
	public static void bubbleSort(double[] list) {
		double tmp;
		for (int i = 0; i < (list.length - 1); i++) {
			for (int j = 0; j < list.length - i - 1; j++) {
				if (list[j] > list[j + 1])  
				{
					tmp = list[j];
					list[j] = list[j + 1];
					list[j + 1] = tmp;
				}
			}
		}
	}
	
	

	/**
	 * Prints the contents of the array to standard output.
	 * 
	 * @param list  list of numbers to be printed
	 */
	public static void printArray(double[] list) {
		for (int i = 0; i < list.length; i++) {
			System.out.printf("%7.2f", list[i]);
		}
		System.out.printf("\n");
	}

}
