package lecture05;

import processing.core.PApplet;
import processing.core.PImage;

/**
 * This program demonstrates how to find pixels in the image with specific
 * characteristics.
 * Press the following keys to find pixels: 
 * b - show the location of the last the brightest pixel
 * a - show the locations of all brightest pixels
 * g - show the location of all pixels with the highest green intensity
 *
 * @author Joanna Klukowska
 *
 */
@SuppressWarnings("serial")
public class FindBrightest_GUI extends PApplet {

	PImage img;
	PImage imgCopy;
	int x, y;
	int locationBright;
	int locationGreen;
	int[] allMax;
	int[] allMaxGreen;

	public void setup() {
		// load the image from file
		
		img = loadImage("Lighthouse.jpg");
		if (img == null) {
			System.err.print("The image you are trying to use is inaccessible.\n" +
						"If using Eclipse, put your image in the src directory, \n" +
						"or specify the full path.\n\n") ;
			System.exit(-1);
		}
		
		//if image is too large for the screen, resize it
		float resizeFactor;
		if (img.height > displayHeight ) {
			resizeFactor = (0.8f*displayHeight) / img.height;
			img.resize((int)(img.width * resizeFactor), 
					(int)(img.height*resizeFactor) );
		}
		if (img.width > displayWidth ) {
			resizeFactor = (0.8f*displayWidth) / img.width;
			img.resize((int)(img.width * resizeFactor), 
					(int)(img.height*resizeFactor) );
		}
		
		// set the canvas size to match the image size
		size(img.width, img.height);

		// get the pixels from the image into
		// a pixels[] array of colors
		loadPixels();

		//compute the location of the last brightest and "greenest" pixels
		locationBright = findMaxBrightness(img.pixels);
		locationGreen  = findMaxGreen(img.pixels);
		//get the x an y values for the brightest pixel
		x = locationBright % img.width;
		y = locationBright / img.width;

		//compute the locations of all brightest and "greenest" pixels 
		allMax = findAllMaxBrigtness(img.pixels, locationBright);
		allMaxGreen = findAllMaxGreen(img.pixels);
		

	}

	public void draw() {
		
		//redraw the image in the canvas 
		image(img, 0, 0);

		//show the last pixel with the brightest intensity
		if (keyPressed == true && key == 'b') {
			fill(255, 0, 0);
			ellipse(x, y, 10, 10);
		}
		
		//show all pixels whose intensity is equal to the brightest pixel
		if (keyPressed == true && key == 'a') {
			fill(170, 0, 127);
			for (int i = 0; i < allMax.length; i++)
				ellipse(allMax[i] % img.width, allMax[i] / img.width, 10, 10);
		}
		
		if (keyPressed == true && key == 'g') {
			fill(0, 255, 0);
			for (int i = 0; i < allMaxGreen.length; i++)
				ellipse(allMaxGreen[i] % img.width, 
						allMaxGreen[i] / img.width, 10, 10);
		}
	}

	/**
	 * This method determines the location of the last brightest pixel
	 * in the image. 
	 * @param pixels the 1D array of pixels to look at
	 * @return the index of the brightest pixel
	 */
	public int findMaxBrightness(int[] pixels) {
		float max = brightness(pixels[0]);
		int index = 0;
		for (int i = 1; i < pixels.length; i++)
			if (max <= brightness(pixels[i])) {
				max = brightness(pixels[i]);
				index = i;
			}
		return index;
	}

	/**
	 * This method determines the locations of all pixels with maximum
	 * brightness in the image
	 * @param pixels the 1D array of pixels to look at
	 * @param locationOfMax the location of the last brightest pixel
	 * @return the array of all the brightest pixels locations
	 */
	public int[] findAllMaxBrigtness(int[] pixels, int locationOfMax) {
		float max = brightness(pixels[locationOfMax]);
		int counterOfMax = 0;
		// first count how many pixels are equal to max
		for (int i = 0; i < pixels.length; i++) {
			if (max == brightness(pixels[i])) {
				counterOfMax++;
			}
		}
		int[] listOfMaxLocations = new int[counterOfMax];
		// record all of the max locations
		int index = 0;
		for (int i = 1; i < pixels.length; i++) {
			if (max == brightness(pixels[i])) {
				listOfMaxLocations[index] = i;
				index++;
			}
		}
		return listOfMaxLocations;
	}

	/**
	 * This method determines the location of the last "greenest" pixel
	 * in the image. 
	 * @param pixels the 1D array of pixels to look at
	 * @return the index of the "greenest" pixel
	 */
	public int findMaxGreen(int[] pixels) {
		float max = blue(pixels[0]);
		int index = 0;
		for (int i = 1; i < pixels.length; i++)
			if (max <= blue(pixels[i])) {
				max = blue(pixels[i]);
				index = i;
			}
		return index;
	}
	

	/**
	 * This method determines the locations of all pixels with maximum
	 * "greenness"  in the image
	 * @param pixels the 1D array of pixels to look at
	 * @param locationOfMax the location of the last "greenest" pixel
	 * @return the array of all the "greenest" pixels locations
	 */
	public int[] findAllMaxGreen(int[] pixels ) {
		float max = green( findMaxGreen( pixels ) ); 
		System.out.println(max);
		int counterOfMax = 0;
		// first count how many pixels are equal to max
		for (int i = 0; i < pixels.length; i++) {
			if (max == green(pixels[i])) {
				counterOfMax++;
			}
		}
		System.out.println(counterOfMax);
		int[] listOfMaxLocations = new int[counterOfMax];
		// record all of the max locations
		int index = 0;
		for (int i = 1; i < pixels.length; i++) {
			if (max == green(pixels[i])) {
				listOfMaxLocations[index] = i;
				index++;
			}
		}
		return listOfMaxLocations;
	}

}
