package lecture05;

/**
 * This program demonstrates several different operations on an array
 * of String objects. 
 * @author Joanna Klukowska
 *
 */
public class ArrayOperations {

	public static void main(String[] args) {
		String [] fruits = {"Apple", "Apricot", "Banana", 
				"Bilberry", "Blackberry", "Blackcurrant", 
				"Blueberry", "Coconut", "Currant", "Cherry", 
				"Cherimoya", "Clementine", "Date", "Damson", 
				"Durian", "Elderberry", "Fig", "Feijoa", 
				"Gooseberry", "Grape", "Grapefruit", "Huckleberry", 
				"Jackfruit", "Jambul", "Jujube", "Kiwifruit", "Kumquat",
				"Lemon", "Lime", "Loquat", "Lychee", "Mango", "Mangostine", 
				"Melon", "Cantaloupe", "Honeydew", "Watermelon", 
				"Rock melon", "Nectarine", "Orange", "Passionfruit", 
				"Peach", "Pear", "Plum", "Prune", "Pineapple", 
				"Pomegranate", "Pomelo", "Raisin", "Raspberry", "Rambutan", 
				"Redcurrant", "Satsuma", "Strawberry", "Tangerine", 
				"Ugli Fruit"};
		
		String [] mixedFruits = shuffleArray(fruits);
		for (int i =0; i < fruits.length; i++ ) {
			System.out.printf("%-15s\t%-15s\n", fruits[i], mixedFruits[i]);
		}
		System.out.printf("\n");
		
		
		String myFruit = "Pomelo";
		int index1 = findFruit (fruits, myFruit);
		int index2 = findFruit (mixedFruits, myFruit);
		if ( index1 < 0)
			System.out.printf("Sorry, we have no %s\n", myFruit);
		else {
			System.out.printf("%s is at index %d in fruits\n"
					+ "and at index %d in mixedFruits. \n", 
					myFruit, index1, index2);
		}
			
		
		
		
	}
	
	/**
	 * Computes and returns a shuffled version of a given list. 
	 * The original list is not modified. 
	 * @param list the array to be shuffled
	 * @return an array containing exactly same elements as the 
	 * parameter array, but in a different (pseudo-random) order
	 */
	public static String [] shuffleArray (String [] list ) {
		String [] mixedList = new String[list.length ];
		
		//make a copy of the parameter array first
		for (int i = 0; i < list.length; i++ )
			mixedList[i] = list[i];
		
		//shuffle the entries in the mixedList
		int pos1, pos2;
		for (int i = 0; i < mixedList.length; i++) {
			pos1 = (int) (Math.random()*(mixedList.length) );
			pos2 = (int) (Math.random()*(mixedList.length) );
			swap ( mixedList, pos1, pos2 );
		}
		
		return mixedList;
	}

	/**
	 * Swaps values of two elements in an array.
	 * If either pos1 or pos2 is larger than the size of the list,
	 * array is not changed. 
	 * @param list array of strings
	 * @param pos1 position of the first string
	 * @param pos2 positon of the second string
	 */
	public static void swap ( String [] list, int pos1, int pos2 ) {
		if (pos1 >= list.length || pos2 >= list.length )
			return;
		String tmp = list[pos1];
		list[pos1] = list[pos2];
		list[pos2] = tmp;
	}
	
	/**
	 * Finds the index of the specified key in the list. 
	 * @param list array of strings to search
	 * @param key string to search for
	 * @return index of the key in the list, or -1 if not found
	 */
	public static int findFruit(String [] list, String key) {
		
		for (int i = 0; i < list.length; i++ ) {
			if (list[i].equals( key) ) 
				return i;
		}
		return -1;
	}

}
