
package lecture04;

/**
 * This program demonstrates passing
 * a String object to a method. It defines 
 * several methods that operate on String
 * objects as well as uses some of the
 * methods from String class. 
 * 
 * @author Joanna Klukowska
 *
 */
public class StringMethods {

	public static void main(String[] args) {
		String s1 = "This is a string without stars";
		String s2 = "This * string has * several *s";
		
		char x = s1.charAt(5);
		System.out.println( x + "  " + (int)x   );
		System.out.println( 'a' + "  " + (int)'a'   );
		
		if (findStar(s1) == -1 )
			System.out.println("No stars here\n");
		else
			System.out.println("Star found at " + s1.indexOf('*')  );

		int indexOfStar = findStar(s2);
		
		if ( indexOfStar == -1 )
			System.out.println("No stars here\n");
		else
			System.out.println("Star found at " + indexOfStar );
		
		int lastIndexOfStar = findLastStar(s2);
		
		if ( lastIndexOfStar == -1 )
			System.out.println("No stars here\n");
		else
			System.out.println("Star found at " + lastIndexOfStar );

	}
	
	
	
	
	
	
	/**
	 * Determine if the parameter string contains stars (character '*').
	 * @param s the String object to be examined
	 * @return index of the first star character in the string,
	 *    or -1 if no star is found 
	 */
	public static int findStar( String s ) {
		
		for (int i = 0; i < s.length(); i++ ) {
			if ( s.charAt( i ) == '*'  ) {
				return i;
			}
		}
		
		return -1;
		
	}
	
	/**
	 * Determine if the parameter string contains stars (character '*') 
	 * and find location of the last star.
	 * @param s the String object to be examined
	 * @return index of the last star character in the string,
	 *    or -1 if no star is found 
	 */
	public static int findLastStar( String s ) {
	
		for (int i = s.length()-1; i >= 0; i-- ) {
			if ( s.charAt( i ) == '*'  ) {
				return i;
			}
		}
	
		return -1;
	
	}

}
