package lecture04;

import processing.core.PApplet;

@SuppressWarnings("serial")
public class SmileyGrid extends PApplet {

	public void setup() {
		// create the square canvas
		size(500, 500);
		
		//draw background 
		background(0, 0, 0);
		
		frameRate(20);
	}
	
	//This method is called by PApplet class in an infinite loop.
	public void draw() {
		//draw background 
		background(0, 0, 0);
		
		for (int x = 0; x < 10; x++){ 
			for (int y = 0; y < 10; y++) {
				//change the color of the ellipse depending on the position
				fill( x*25, y*25, 255-25*(x+y)/2 );
				
				//vibrate the circles by randomly adding a value between 
				//zero and 5 to x and y coordinates of the center (this is done by second line) 
				drawSmiley (50*x + 25 , 50*y + 25 );
				//drawSmiley (50*x + 25 + random(5), 50*y + 25 + random(5) );
			}
		}
	}
	
	public void drawSmiley ( float x,  float y ) {
		//draw the "head"
		ellipse ( x, y, 30, 30);
		//draw eyes
		fill(50,50,50,200);
		ellipse ( x + 5, y - 5, 2, 4);
		ellipse ( x - 5, y - 5, 2, 4);
		//draw the smile
		//the depth of the smile depends on position
		arc ( x, y+2, 20, (int)(x+y)%23, QUARTER_PI/2, 7*QUARTER_PI/2, OPEN);
	}
}
