package lecture04;

import java.util.Scanner;

/**
 * This program displays certain properties of a number entered by
 * the user. Given a number, the program displays if the number is even,
 * odd, prime, and its binary conversion. 
 * @author Joanna Klukowska
 * @version Feb 16, 2014 
 *
 */
public class NumberProperties {

	public static void main(String[] args) {
		Scanner in = new Scanner (System.in ) ;
		int number;
		
		//get a number
		System.out.printf("Enter a number between %d and %d: ",
				Short.MIN_VALUE, Short.MAX_VALUE );
		number = in.nextInt();
		
		if (number < Short.MIN_VALUE || number > Short.MAX_VALUE ) {
			System.err.printf("ERROR: Number outside of the range.");
		}
		else {
			System.out.printf("You entered %d.\n", number);
			System.out.printf("Even:  %5b\n", isEven(number));
			System.out.printf("Odd:   %5b\n", isOdd(number));
			System.out.printf("Prime: %5b\n", isPrime(number));
			//we make use of the method defined in a different file (class)
			System.out.printf("Binary: %s\n", 
					DecimalToBinary.convertToBinary((short)(number)));
		}
		
		in.close();
	}
	
	/**
	 * Determine if the number is even.
	 * @param number
	 *   number to be tested
	 * @return
	 *   true if number is even
	 *   false otherwise
	 */
	public static boolean isEven (int number ) {
		if (number % 2 == 0 )
			return true;
		else
			return false;
	}
	
	
	/**
	 * Determines is number is small.
	 * @param number
	 * 	 number to be tested
	 * @return
	 *   true if number is less than 100
	 *   false otherwise 
	 */
	public static boolean isSmall (int number ) {
		if (number < 100 )
			return true;
		else 
			return false;
	}
	
	/**
	 * Determine if the number if odd.
	 * @param number
	 *   number to be tested
	 * @return
	 *   true if number is odd,
	 *   false otherwise
	 */
	public static boolean isOdd (int number ) {
		if (number % 2 == 1 )
			return true;
		else
			return false;
	}
	
	/**
	 * Determines if the number is prime.
	 * WARNING: there are better implementations of this method!
	 * @param number
	 *    number to be tested
	 * @return
	 *    true if the number is prime,
	 *    false otherwise 
	 */
	public static boolean isPrime ( int number ) {
		//primes are numbers that are divisible
		//only by itself and 1
		//to test if number is prime we can try to 
		//divide by all numbers between 1 and itself
		//if it is divisible (without a remainder) 
		//then we know it is not prime
		int divisor = 2;
		while (divisor < number ) {
			if (number % divisor == 0 ) {
				//we found a factor, so it is not prime
				return false;
			}
			divisor++;
		}
		//we did not find any factors
		return true;
	}

}
