package lecture04;

/**
 * This program demonstrates use of overloaded methods.
 * It implements three versions of a max(...) method that 
 * work with different parameter lists.
 * @author Joanna Klukowska
 * @version Feb 16, 2014 
 *
 */
public class MaxOverloaded {

	/** Main method */
	public static void main(String[] args) {
		
		// Invoke the max method with int parameters
		System.out.println("The maximum between 3 and 4 is " + max(3, 4));

		// Invoke the max method with the double parameters
		System.out.println("The maximum between 3.0 and 5.4 is "
				+ max(3.0, 5.4));

		// Invoke the max method with three double parameters
		System.out.println("The maximum between 3.0, 5.4, and 10.14 is "
				+ max(3.0, 5.4, 10.14));
		

		// Invoke the max method with mixed parameters
		System.out.println("The maximum between 7 and 13.6 is "
				+ max(7 , 13.6));
	}

	/** 
	 * Return the max between two integers
	 * @param num1
	 *    first number 
	 * @param num2
	 *    second number 
	 * @return
	 *    larger of the num1 and num2
	 */
	public static int max(int num1, int num2) {
		if (num1 > num2)
			return num1;
		else
			return num2;
	}

	/** 
	 * Return the max between two real numbers
	 * @param num1
	 *    first number 
	 * @param num2
	 *    second number 
	 * @return
	 *    larger of the num1 and num2
	 */
	public static double max(double num1, double num2) {
		if (num1 > num2)
			return num1;
		else
			return num2;
	}

	/** 
	 * Return the max between three real numbers
	 * @param num1
	 *    first number 
	 * @param num2
	 *    second number 
	 * @param num3
	 *    third number 
	 * @return
	 *    largest of the num1, num2 and num3
	 */
	 public static double max(double num1, double num2, double num3) {
		return max(max(num1, num2), num3);
	}

}
