package lecture04;

/**
 * This program displays a table of first 10 powers of 2 
 * and their binary equivalents.
 * @author Joanna Klukowska
 * @version Feb 16, 2014 
 *
 */
public class DecimalToBinary {

	public static void main(String[] args) {
		//display a table to first ten powers of
		//two in decimal and in binary
		for (short i = 1; i <= 1024; i=(short)(i*2) ) {
			System.out.printf("%10d in decimal = %18s in binary\n", 
					i, convertToBinary(i) );
		}
		short n = 22123;
		System.out.printf("%10d in decimal = %18s in binary\n", 
				n, convertToBinary(n) );
	}
	
	/**
	 * Convert decimal integers to their
	 * binary string equivalents.
	 * @param decNumber
	 *    decimal integer number to convert
	 * @return
	 *    string representing the binary version
	 *    of decNumber 
	 */
	public static String convertToBinary ( short decNumber ) {
		
	    short bit = 0;
	    String output = "";
	    //loop over all the bits extracting the rightmost
	    //one and shifting on each iteration
	    while (decNumber > 0 ) {
	    	//get the remainder 
	    	bit = (short) (decNumber % 2) ;
	    	//divide by 2
	    	decNumber = (short) ( decNumber / 2);
	    	//save the last bit to an output string 
	    	output = bit+ output;
	    }
	    
	    return output;
	}

}
