
package lecture04;

import java.util.Scanner;

/**
 * This class provides methods and the program used for conversion
 * of user-entered binary numbers to decimal numbers.
 * @author Joanna Klukowska
 *
 */
public class BinaryToDecimal {

	public static void main(String[] args) {

		Scanner input = new Scanner( System.in );

		//get the number for the user
		System.out.print("Enter the binary number you want to convert: ");
		String numberEntered = input.next();

		//check if it is a valid binary number
		if ( !isValid(numberEntered)) {
			System.err.println("ERRO: This is not a valid binary number.");
			System.exit(1);
		}

		int number = convert(numberEntered);
		System.out.printf("%32s in binary = %6d in decimal",
				numberEntered, number);


		input.close();
	}

	/**
	 * Determines if the binaryNum string is a valid binary number.
	 * @param binaryNum string to validate
	 * @return true if binaryNum contains only zeroes and ones, 
	 *         false otherwise
	 */
	public static boolean isValid ( String binaryNum ) {

		for (int i = 0; i < binaryNum.length(); i++ ) {
			if (binaryNum.charAt(i) != '0' 
					&& binaryNum.charAt(i)!= '1' )
				return false;
		}
		return true;
	}

	/**
	 * Converts binaryNum to its decimal equivalent.
	 * Assumption: binaryNum is a valid binary number that
	 * consists only of zeroes and ones. 
	 * @param binaryNum string containing the binary number
	 * @return decimal equivalent to the binary string
	 */
	public static int convert ( String binaryNum ) {
		int num = 0;
		for (int i = 0; i < binaryNum.length(); i++ ){ 
			int exponent = binaryNum.length() - i - 1;
			if (binaryNum.charAt(i) == '1')
				num += Math.pow(2, exponent);
		}

		return num;
	}

}
