package lecture01;

/**
 * This class computes and displays the current time. 
 * The time is computed up to the second.
 * It is displayed ad GMT and EST. 
 * 
 * @author Joanna Klukowska
 * @version Aug. 31, 2014 
 */
public class ShowCurrentTime {

	public static void main(String[] args) {
		
//		get the number of milliseconds since 
//		midnight, Jan. 1, 1970 (Unix epoch)
//		NOTICE that int uses too few bytes to store such 
//		large number
		long numOfMilliseconds = System.currentTimeMillis();

//		compute the number of seconds, 
//		remember that 1 s = 1000 ms
//		we are going to ignore any "leftover" milliseconds
		long numOfSeconds = numOfMilliseconds/1000; 
		
//		compute the number of minutes,
//		the remainder will tell us the current second
		long numOfMinutes = numOfSeconds / 60;
		long currentSecond = numOfSeconds % 60;
		
//		compute the number of hours,
//		the remainder will tell us the current minute
		long numOfHours = numOfMinutes / 60;
		long currentMinute = numOfMinutes % 60;
		
//		compute the number of days, 
//		the remainder will tell us the current hour
		long numOfDays = numOfHours / 24;
		long currentHour = numOfHours % 24;
		
//		display the time
		System.out.printf("Current time is %02d:%02d:%02d GMT\n",
				currentHour, currentMinute, currentSecond);
		System.out.printf("                %02d:%02d:%02d EST\n",
				(currentHour+20)%24, currentMinute, currentSecond);
		System.out.printf("\n%,d days have passed since January 1, 1970\n\n", numOfDays);
		
		
	}

}
