package lecture01;

import java.util.Scanner;

/* 
 * Problem: 
 * Find the real roots of a quadratic equation written 
 * in ax^2 + bx + c = 0 format.
 *  
 * Algorithm: 
 * 
 * The general solution is given by two mathematical formulas: 
 *   x = (-b + SQRT( b^2 - 4ac) )/2a
 * and 
 *   x = (-b - SQRT( b^2 - 4ac) )/2a
 * There are several conditions that need to be checked though 
 * and in practice a quadratic equation can have infinitely many
 * solutions, two solutions, one solution or no real solutions at all. 
 * The number of solutions depends on the values of a, b and c.
 * 
 * 1) If a, b and c are all zero, then there are infinitely many 
 * solutions (x can be any number you wish).
 * 2) If a is zero and b is not zero, then there is exactly 
 * one solution equal to -c/b.
 * 3) If a is not zero and b^2 = 4ac, then there is exactly one 
 * solution equal to -b/2a.
 * 4) If a is not zero and b^2 > 4ac, then there are two solutions
 * and they can be computed using the general formulas mentioned 
 * at the beginning.
 * 5) In all other cases, there are no solutions. 
 * 
 * Implementation:
 * 
 * In this second implementation, we will check all the conditions mentioned 
 * above and display the appropriate number of solutions. 
 * 
 */

public class QuadraticEquationSolver02 {

	public static void main(String[] args) {
		//print the "welcome screen"
		System.out.println("I solve quadratic equations of the form: ");
		System.out.println("  ax^2 + bx + c = 0 \n");
		
		//the values of a,b and c need to be stored in variables
		double a, b, c;
		//we also need variables to store our two solutions
		double x1, x2;
		
		//we need to read the values of a, b and c from the user
		//so we need to use the Scanner object
		Scanner in = new Scanner (System.in );
		String answer = "y";
		//boolean keepGoing = true;
		do {
			//ask the user to enter the three values
			System.out.println("Enter the values of a, b and c and I will tell you the solutions.");
			System.out.print(" a = ");
			a = in.nextDouble();
			System.out.print(" b = ");
			b = in.nextDouble();
			System.out.print(" c = ");
			c = in.nextDouble();
			
			//the different cases are handled one by one
			
			//If a, b and c are all zero, then there are infinitely many 
			//solutions (x can be any number you wish).
			if (a == 0  &&  b == 0  &&  c == 0 ) {
				System.out.printf("\nThere are inifinitely many solutions: " + 
			                       "any real number is a solution.");
			}
			//If a is zero and b is not zero, then there is exactly 
			// one solution equal to -c/b.
			else if ( a == 0  &&  b != 0  )  {
				x1 = -c/b;
				System.out.printf("\nThere is one solution:\n\tx = %f", x1 );
			}
			//If a is not zero and b^2 = 4ac, then there is exactly one 
			// solution equal to -b/2a.
			else if ( a != 0 && b*b == 4*a*c ){
				x1 = -b/(2*a);
				System.out.printf("\nThere is one solution:\n\tx = %f", x1 );
			}
			//If a is not zero and b^2 > 4ac, then there are two solutions
			// and they can be computed using
			//    x = (-b + SQRT( b^2 - 4ac) )/2a
			// and 
			//    x = (-b - SQRT( b^2 - 4ac) )/2a
			else if ( a != 0 && b*b > 4*a*c ){
				x1 = (-b - Math.sqrt( b * b - 4 * a * c  )) / (2 * a);
				x2 = (-b + Math.sqrt( b * b - 4 * a * c  )) / (2 * a);
				System.out.printf("\nThere are two solutions:\n\tx1 = %15.8f\n\tx2 = %15.8f",
				           x1, x2 );
			}
			//In all other cases, there are no solutions.
			else {
				System.out.printf("\nThere are no real solutions.");
			}
			System.out.println("\n\nDo you want to continue? [y/n]");
			answer = in.next();
			
		} while ( answer.charAt(0) == 'y' ) ;
		
		System.out.println("\n\nThank you for cranching numbers!\n\n");
		
		in.close();
	
	}

}
