package lecture01;

import java.util.Scanner;

/* 
 * @author: Joanna KLukowska
 * 
 * Problem: 
 * Find the real roots of a quadratic equation written 
 * in ax^2 + bx + c = 0 format.
 *  
 * Algorithm: 
 * 
 * The general solution is given by two mathematical formulas: 
 *   x = (-b + SQRT( b^2 - 4ac) )/2a
 * and 
 *   x = (-b - SQRT( b^2 - 4ac) )/2a
 * There are several conditions that need to be checked though 
 * and in practice a quadratic equation can have infinitely many
 * solutions, two solutions, one solution or no real solutions at all. 
 * The number of solutions depends on the values of a, b and c.
 * 
 * 1) If a, b and c are all zero, then there are infinitely many 
 * solutions (x can be any number you wish).
 * 2) If a is zero and b is not zero, then there is exactly 
 * one solution equal to -c/b.
 * 3) If a is not zero and b^2 = 4ac, then there is exactly one 
 * solution equal to -b/2a.
 * 4) If a is not zero and b^2 > 4ac, then there are two solutions
 * and they can be computed using the general formulas mentioned 
 * at the beginning.
 * 5) In all other cases, there are no solutions. 
 * 
 * Implementation:
 * 
 * In this very first implementation of the QuadraticEquationSolver,
 * we will ignore all of the above conditions and keep our fingers crossed
 * that things will go fine. 
 * 
 */

public class QuadraticEquationSolver01 {

	public static void main(String[] args) {
		//print the "welcome screen"
		System.out.println("I solve quadratic equations of the form: ");
		System.out.println("  ax^2 + bx + c = 0 \n");
		
		//the values of a,b and c need to be stored in variables
		double a, b, c;
		//we also need variables to store our two solutions
		double x1, x2;
		
		//we need to read the values of a, b and c from the user
		//so we need to use the Scanner object
		Scanner in = new Scanner (System.in );
		
		//ask the user to enter the three values
		System.out.println("Enter the values of a, b and c and I will tell"
				+ " you the solutions.");
		System.out.print(" a = ");
		a = in.nextDouble();
		System.out.print(" b = ");
		b = in.nextDouble();
		System.out.print(" c = ");
		c = in.nextDouble();
		
		
		//we are ready to compute the first solution
		//NOTICE: there is no exponentiation symbol in Java, we have to use
		//        multiplication to square the values
		//NOTICE: in math the multiplication symbol is optional 2a is the same as 2*a,
		//        in Java you cannot skip the multiplication symbol
		//NOTICE: we need to use a special tool to take square root, more about 
		//        it later on
		x1 = (-b - Math.sqrt( b * b - 4 * a * c  )) / (2 * a);
		//and similarly, we compute the second solution
		x2 = (-b + Math.sqrt( b * b - 4 * a * c  )) / (2 * a);
		
		//after hard work, we can show the user her/his solutions
		System.out.println("\nThe solutions are:\nx1 = " + x1 + "\nx2 = " + x2);
		
		System.out.println("\n\nThank you for cranching numbers!\n\n");
		
		in.close();
	
	}

}
