package lecture01;

/**
 * This class provides an example of use of formatted output in Java. 
 * It introduces the printf method. 
 * 
 * @author Joanna Klukowska
 * @version Jan 24, 2014 
 *
 */
public class PrintfExample {
	public static void main ( String [] args ) {
		//some variables to be used in the examples below
		double radius = 5;
		double area = Math.PI * radius * radius;
		
		boolean x = true, y = false;
		
		String name = "Joanna";
		double tuition = 24063.783;

		// Simple format specifiers consist of % followed by a letter 
		// indicating the type of value that is used to replace the 
		// format specifier. 
		System.out.printf("Area of circle with radius %f is %f.\n", 
				radius, area);
		System.out.printf(
				"Given that x is %b and y is %b, the value of (x&&y) is %b.\n", 
				x, y, x&&y );
		System.out.printf("Student: %s, tuition: $%f.\n", 
				name, tuition );	

		//More complex format specifiers allow you to control the 
		//display of the values by specifying the minimum width of 
		//the field in which the value is displayed and the precision. 
		System.out.println();
		System.out.printf("Area of circle with radius %10.2f is  %10.4f.\n", 
				radius, area);
		System.out.printf("Area of circle with radius %10.4f is %10.4f.\n", 
				15.0, Math.PI*15.0*15.0);
		System.out.printf("Area of circle with radius %10.4f is %10.4f.\n", 
				3.1415, Math.PI*3.1415*3.1415);
		
		System.out.println();
		
		System.out.printf("Student: %9s, tuition: $%9.2f.\n", name, tuition );	
		System.out.printf("Student: %-9s, tuition: $%9.2f.\n", name, tuition );	
		System.out.printf("Student: %9s, tuition: $%09.2f.\n", name, tuition );	
		System.out.printf("Student: %-9s, tuition: $%+9.2f.\n", name, tuition );	
		
	
	}

}
