/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import gnu.trove.TDoubleFunction;
import gnu.trove.TIntDoubleHashMap;
import gnu.trove.TIntDoubleProcedure;
import opennlp.maxent.DataIndexer;
import opennlp.maxent.EventStream;
import opennlp.maxent.GISModel;

class GISTrainer {
    private boolean _simpleSmoothing = false;
    private double _smoothingObservation = 0.1;
    private boolean printMessages = false;
    private int numTokens;
    private int numPreds;
    private int numOutcomes;
    private int TID;
    private int PID;
    private int OID;
    private double SUM;
    private int[][] contexts;
    private int[] outcomes;
    private int[] numTimesEventsSeen;
    private String[] outcomeLabels;
    private String[] predLabels;
    private TIntDoubleHashMap[] observedExpects;
    private TIntDoubleHashMap[] params;
    private TIntDoubleHashMap[] modifiers;
    private int[] predkeys;
    private int constant;
    private double constantInverse;
    private double correctionParam;
    private double cfObservedExpect;
    private double CFMOD;
    private final double NEAR_ZERO = 0.01;
    private final double LLThreshold = 1.0E-4;
    double[] modelDistribution;
    int[] numfeats;
    double iprob;
    private TDoubleFunction backToZeros = new TDoubleFunction(){

        public double execute(double arg) {
            return 0.0;
        }
    };
    private TIntDoubleProcedure updateModifiers = new TIntDoubleProcedure(){

        public boolean execute(int oid, double arg) {
            GISTrainer.this.modifiers[GISTrainer.this.PID].put(oid, arg + GISTrainer.this.modelDistribution[oid] * (double)GISTrainer.this.numTimesEventsSeen[GISTrainer.this.TID]);
            return true;
        }
    };
    private TIntDoubleProcedure updateParams = new TIntDoubleProcedure(){

        public boolean execute(int oid, double arg) {
            GISTrainer.this.params[GISTrainer.this.PID].put(oid, arg + (GISTrainer.this.observedExpects[GISTrainer.this.PID].get(oid) - Math.log(GISTrainer.this.modifiers[GISTrainer.this.PID].get(oid))));
            return true;
        }
    };

    GISTrainer() {
    }

    GISTrainer(boolean printMessages) {
        this();
        this.printMessages = printMessages;
    }

    private void display(String s) {
        if (this.printMessages) {
            System.out.print(s);
        }
    }

    public void eval(int[] context, double[] outsums) {
        int oid;
        int oid2 = 0;
        while (oid2 < this.numOutcomes) {
            outsums[oid2] = this.iprob;
            this.numfeats[oid2] = 0;
            ++oid2;
        }
        int i = 0;
        while (i < context.length) {
            TIntDoubleHashMap predParams = this.params[context[i]];
            int[] activeOutcomes = predParams.keys();
            int j = 0;
            while (j < activeOutcomes.length) {
                int n = oid = activeOutcomes[j];
                this.numfeats[n] = this.numfeats[n] + 1;
                int n2 = oid;
                outsums[n2] = outsums[n2] + this.constantInverse * predParams.get(oid);
                ++j;
            }
            ++i;
        }
        double SUM = 0.0;
        oid = 0;
        while (oid < this.numOutcomes) {
            outsums[oid] = Math.exp(outsums[oid] + (1.0 - (double)this.numfeats[oid] / (double)this.constant) * this.correctionParam);
            SUM += outsums[oid];
            ++oid;
        }
        int oid3 = 0;
        while (oid3 < this.numOutcomes) {
            int n = oid3++;
            outsums[n] = outsums[n] / SUM;
        }
    }

    private void findParameters(int iterations) {
        double prevLL = 0.0;
        double currLL = 0.0;
        this.display("Performing " + iterations + " iterations.\n");
        int i = 1;
        while (i <= iterations) {
            if (i < 10) {
                this.display("  " + i + ":  ");
            } else if (i < 100) {
                this.display(" " + i + ":  ");
            } else {
                this.display(String.valueOf(i) + ":  ");
            }
            currLL = this.nextIteration();
            if (i > 1) {
                if (prevLL > currLL) {
                    System.err.println("Model Diverging: loglikelihood decreased");
                    break;
                }
                if (currLL - prevLL < 1.0E-4) break;
            }
            prevLL = currLL;
            ++i;
        }
        this.observedExpects = null;
        this.modifiers = null;
        this.numTimesEventsSeen = null;
        this.contexts = null;
    }

    private double nextIteration() {
        double loglikelihood = 0.0;
        this.CFMOD = 0.0;
        int numEvents = 0;
        this.TID = 0;
        while (this.TID < this.numTokens) {
            this.eval(this.contexts[this.TID], this.modelDistribution);
            int j = 0;
            while (j < this.contexts[this.TID].length) {
                this.PID = this.contexts[this.TID][j];
                this.modifiers[this.PID].forEachEntry(this.updateModifiers);
                this.OID = 0;
                while (this.OID < this.numOutcomes) {
                    if (!this.modifiers[this.PID].containsKey(this.OID)) {
                        this.CFMOD += this.modelDistribution[this.OID] * (double)this.numTimesEventsSeen[this.TID];
                    }
                    ++this.OID;
                }
                ++j;
            }
            this.CFMOD += (double)((this.constant - this.contexts[this.TID].length) * this.numTimesEventsSeen[this.TID]);
            loglikelihood += Math.log(this.modelDistribution[this.outcomes[this.TID]]) * (double)this.numTimesEventsSeen[this.TID];
            numEvents += this.numTimesEventsSeen[this.TID];
            ++this.TID;
        }
        this.display(".");
        this.PID = 0;
        while (this.PID < this.numPreds) {
            this.params[this.PID].forEachEntry(this.updateParams);
            this.modifiers[this.PID].transformValues(this.backToZeros);
            ++this.PID;
        }
        if (this.CFMOD > 0.0) {
            this.correctionParam += this.cfObservedExpect - Math.log(this.CFMOD);
        }
        this.display(". loglikelihood=" + loglikelihood + "\n");
        return loglikelihood;
    }

    public void setSmoothing(boolean smooth) {
        this._simpleSmoothing = smooth;
    }

    public void setSmoothingObservation(double timesSeen) {
        this._smoothingObservation = timesSeen;
    }

    public GISModel trainModel(EventStream eventStream, int iterations, int cutoff) {
        int initialCapacity;
        DataIndexer di = new DataIndexer(eventStream, cutoff);
        this.display("Incorporating indexed data for training...  \n");
        this.contexts = di.contexts;
        this.outcomes = di.outcomeList;
        this.numTimesEventsSeen = di.numTimesEventsSeen;
        this.numTokens = this.contexts.length;
        this.constant = this.contexts[0].length;
        this.TID = 1;
        while (this.TID < this.contexts.length) {
            if (this.contexts[this.TID].length > this.constant) {
                this.constant = this.contexts[this.TID].length;
            }
            ++this.TID;
        }
        this.constantInverse = 1.0 / (double)this.constant;
        this.display("done.\n");
        this.outcomeLabels = di.outcomeLabels;
        this.numOutcomes = this.outcomeLabels.length;
        this.iprob = Math.log(1.0 / (double)this.numOutcomes);
        this.predLabels = di.predLabels;
        this.numPreds = this.predLabels.length;
        this.display("\tNumber of Event Tokens: " + this.numTokens + "\n");
        this.display("\t    Number of Outcomes: " + this.numOutcomes + "\n");
        this.display("\t  Number of Predicates: " + this.numPreds + "\n");
        int[][] predCount = new int[this.numPreds][this.numOutcomes];
        this.TID = 0;
        while (this.TID < this.numTokens) {
            int j = 0;
            while (j < this.contexts[this.TID].length) {
                int[] nArray = predCount[this.contexts[this.TID][j]];
                int n = di.outcomeList[this.TID];
                nArray[n] = nArray[n] + this.numTimesEventsSeen[this.TID];
                ++j;
            }
            ++this.TID;
        }
        di = null;
        double smoothingObservation = this._smoothingObservation;
        double logSmoothingObservation = Math.log(this._smoothingObservation);
        this.params = new TIntDoubleHashMap[this.numPreds];
        this.modifiers = new TIntDoubleHashMap[this.numPreds];
        this.observedExpects = new TIntDoubleHashMap[this.numPreds];
        float loadFactor = 0.9f;
        if (this.numOutcomes < 3) {
            initialCapacity = 2;
            loadFactor = 1.0f;
        } else {
            initialCapacity = this.numOutcomes < 5 ? 2 : this.numOutcomes / 2;
        }
        this.PID = 0;
        while (this.PID < this.numPreds) {
            this.params[this.PID] = new TIntDoubleHashMap(initialCapacity, loadFactor);
            this.modifiers[this.PID] = new TIntDoubleHashMap(initialCapacity, loadFactor);
            this.observedExpects[this.PID] = new TIntDoubleHashMap(initialCapacity, loadFactor);
            this.OID = 0;
            while (this.OID < this.numOutcomes) {
                if (predCount[this.PID][this.OID] > 0) {
                    this.params[this.PID].put(this.OID, 0.0);
                    this.modifiers[this.PID].put(this.OID, 0.0);
                    this.observedExpects[this.PID].put(this.OID, Math.log(predCount[this.PID][this.OID]));
                } else if (this._simpleSmoothing) {
                    this.params[this.PID].put(this.OID, 0.0);
                    this.modifiers[this.PID].put(this.OID, 0.0);
                    this.observedExpects[this.PID].put(this.OID, logSmoothingObservation);
                }
                ++this.OID;
            }
            this.params[this.PID].compact();
            this.modifiers[this.PID].compact();
            this.observedExpects[this.PID].compact();
            ++this.PID;
        }
        int cfvalSum = 0;
        this.TID = 0;
        while (this.TID < this.numTokens) {
            int j = 0;
            while (j < this.contexts[this.TID].length) {
                this.PID = this.contexts[this.TID][j];
                if (!this.modifiers[this.PID].containsKey(this.outcomes[this.TID])) {
                    cfvalSum += this.numTimesEventsSeen[this.TID];
                }
                ++j;
            }
            cfvalSum += (this.constant - this.contexts[this.TID].length) * this.numTimesEventsSeen[this.TID];
            ++this.TID;
        }
        this.cfObservedExpect = cfvalSum == 0 ? Math.log(0.01) : Math.log(cfvalSum);
        this.correctionParam = 0.0;
        predCount = null;
        this.display("...done.\n");
        this.modelDistribution = new double[this.numOutcomes];
        this.numfeats = new int[this.numOutcomes];
        this.display("Computing model parameters...\n");
        this.findParameters(iterations);
        return new GISModel(this.params, this.predLabels, this.outcomeLabels, this.constant, this.correctionParam);
    }
}

