/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import gnu.trove.TIntDoubleHashMap;
import gnu.trove.TObjectIntHashMap;
import opennlp.maxent.MaxentModel;

public final class GISModel
implements MaxentModel {
    private final TIntDoubleHashMap[] params;
    private final TObjectIntHashMap pmap;
    private final String[] ocNames;
    private final double correctionConstant;
    private final double correctionParam;
    private final int numOutcomes;
    private final double iprob;
    private final double fval;
    private int[] numfeats;

    public GISModel(TIntDoubleHashMap[] _params, String[] predLabels, String[] _ocNames, int _correctionConstant, double _correctionParam) {
        this.pmap = new TObjectIntHashMap(predLabels.length);
        int i = 0;
        while (i < predLabels.length) {
            this.pmap.put((Object)predLabels[i], i);
            ++i;
        }
        this.params = _params;
        this.ocNames = _ocNames;
        this.correctionConstant = _correctionConstant;
        this.correctionParam = _correctionParam;
        this.numOutcomes = this.ocNames.length;
        this.iprob = Math.log(1.0 / (double)this.numOutcomes);
        this.fval = 1.0 / this.correctionConstant;
        this.numfeats = new int[this.numOutcomes];
    }

    public final double[] eval(String[] context) {
        return this.eval(context, new double[this.numOutcomes]);
    }

    public final double[] eval(String[] context, double[] outsums) {
        int oid;
        int oid2 = 0;
        while (oid2 < this.numOutcomes) {
            outsums[oid2] = this.iprob;
            this.numfeats[oid2] = 0;
            ++oid2;
        }
        int i = 0;
        while (i < context.length) {
            if (this.pmap.containsKey((Object)context[i])) {
                TIntDoubleHashMap predParams = this.params[this.pmap.get((Object)context[i])];
                int[] activeOutcomes = predParams.keys();
                int j = 0;
                while (j < activeOutcomes.length) {
                    int n = oid = activeOutcomes[j];
                    this.numfeats[n] = this.numfeats[n] + 1;
                    int n2 = oid;
                    outsums[n2] = outsums[n2] + this.fval * predParams.get(oid);
                    ++j;
                }
            }
            ++i;
        }
        double normal = 0.0;
        oid = 0;
        while (oid < this.numOutcomes) {
            outsums[oid] = Math.exp(outsums[oid] + (1.0 - (double)this.numfeats[oid] / this.correctionConstant) * this.correctionParam);
            normal += outsums[oid];
            ++oid;
        }
        int oid3 = 0;
        while (oid3 < this.numOutcomes) {
            int n = oid3++;
            outsums[n] = outsums[n] / normal;
        }
        return outsums;
    }

    public final String getAllOutcomes(double[] ocs) {
        if (ocs.length != this.ocNames.length) {
            return "The double array sent as a parameter to GISModel.getAllOutcomes() must not have been produced by this model.";
        }
        StringBuffer sb = new StringBuffer(ocs.length * 2);
        String d = Double.toString(ocs[0]);
        if (d.length() > 6) {
            d = d.substring(0, 7);
        }
        sb.append(this.ocNames[0]).append("[").append(d).append("]");
        int i = 1;
        while (i < ocs.length) {
            d = Double.toString(ocs[i]);
            if (d.length() > 6) {
                d = d.substring(0, 7);
            }
            sb.append("  ").append(this.ocNames[i]).append("[").append(d).append("]");
            ++i;
        }
        return sb.toString();
    }

    public final String getBestOutcome(double[] ocs) {
        int best = 0;
        int i = 1;
        while (i < ocs.length) {
            if (ocs[i] > ocs[best]) {
                best = i;
            }
            ++i;
        }
        return this.ocNames[best];
    }

    public final Object[] getDataStructures() {
        Object[] data = new Object[]{this.params, this.pmap, this.ocNames, new Integer((int)this.correctionConstant), new Double(this.correctionParam)};
        return data;
    }

    public int getIndex(String outcome) {
        int i = 0;
        while (i < this.ocNames.length) {
            if (this.ocNames[i].equals(outcome)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getNumOutcomes() {
        return this.numOutcomes;
    }

    public final String getOutcome(int i) {
        return this.ocNames[i];
    }
}

