/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import gnu.trove.TIntArrayList;
import gnu.trove.TLinkedList;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import opennlp.maxent.ComparableEvent;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;

public class DataIndexer {
    public int[][] contexts;
    public int[] outcomeList;
    public int[] numTimesEventsSeen;
    public String[] predLabels;
    public String[] outcomeLabels;

    public DataIndexer(EventStream eventStream) {
        this(eventStream, 0);
    }

    public DataIndexer(EventStream eventStream, int cutoff) {
        TObjectIntHashMap predicateIndex = new TObjectIntHashMap();
        System.out.println("Indexing events using cutoff of " + cutoff + "\n");
        System.out.print("\tComputing event counts...  ");
        TLinkedList events = this.computeEventCounts(eventStream, predicateIndex, cutoff);
        System.out.println("done. " + events.size() + " events");
        System.out.print("\tIndexing...  ");
        List eventsToCompare = this.index(events, predicateIndex);
        events = null;
        predicateIndex = null;
        System.out.println("done.");
        System.out.print("Sorting and merging events... ");
        this.sortAndMerge(eventsToCompare);
        System.out.println("Done indexing.");
    }

    private TLinkedList computeEventCounts(EventStream eventStream, TObjectIntHashMap predicatesInOut, int cutoff) {
        TObjectIntHashMap counter = new TObjectIntHashMap();
        TLinkedList events = new TLinkedList();
        int predicateIndex = 0;
        while (eventStream.hasNext()) {
            Event ev = eventStream.nextEvent();
            events.addLast((Object)ev);
            String[] ec = ev.getContext();
            int j = 0;
            while (j < ec.length) {
                if (!predicatesInOut.containsKey((Object)ec[j])) {
                    if (!counter.increment((Object)ec[j])) {
                        counter.put((Object)ec[j], 1);
                    }
                    if (counter.get((Object)ec[j]) >= cutoff) {
                        predicatesInOut.put((Object)ec[j], predicateIndex++);
                        counter.remove((Object)ec[j]);
                    }
                }
                ++j;
            }
        }
        predicatesInOut.trimToSize();
        return events;
    }

    private List index(TLinkedList events, TObjectIntHashMap predicateIndex) {
        TObjectIntHashMap omap = new TObjectIntHashMap();
        int numEvents = events.size();
        int outcomeCount = 0;
        boolean predCount = false;
        ArrayList<ComparableEvent> eventsToCompare = new ArrayList<ComparableEvent>(numEvents);
        TIntArrayList indexedContext = new TIntArrayList();
        int eventIndex = 0;
        while (eventIndex < numEvents) {
            int ocID;
            Event ev = (Event)((Object)events.removeFirst());
            String[] econtext = ev.getContext();
            String oc = ev.getOutcome();
            if (omap.containsKey((Object)oc)) {
                ocID = omap.get((Object)oc);
            } else {
                ocID = outcomeCount++;
                omap.put((Object)oc, ocID);
            }
            int i = 0;
            while (i < econtext.length) {
                String pred = econtext[i];
                if (predicateIndex.containsKey((Object)pred)) {
                    indexedContext.add(predicateIndex.get((Object)pred));
                }
                ++i;
            }
            if (indexedContext.size() > 0) {
                ComparableEvent ce = new ComparableEvent(ocID, indexedContext.toNativeArray());
                eventsToCompare.add(ce);
            } else {
                System.err.println("Dropped event " + ev.getOutcome() + ":" + Arrays.asList(ev.getContext()));
            }
            indexedContext.resetQuick();
            ++eventIndex;
        }
        this.outcomeLabels = DataIndexer.toIndexedStringArray(omap);
        this.predLabels = DataIndexer.toIndexedStringArray(predicateIndex);
        return eventsToCompare;
    }

    private void sortAndMerge(List eventsToCompare) {
        Collections.sort(eventsToCompare);
        int numEvents = eventsToCompare.size();
        int numUniqueEvents = 1;
        if (numEvents <= 1) {
            return;
        }
        ComparableEvent ce = (ComparableEvent)eventsToCompare.get(0);
        int i = 1;
        while (i < numEvents) {
            ComparableEvent ce2 = (ComparableEvent)eventsToCompare.get(i);
            if (ce.compareTo(ce2) == 0) {
                ++ce.seen;
                eventsToCompare.set(i, null);
            } else {
                ce = ce2;
                ++numUniqueEvents;
            }
            ++i;
        }
        System.out.println("done. Reduced " + numEvents + " events to " + numUniqueEvents + ".");
        this.contexts = new int[numUniqueEvents][];
        this.outcomeList = new int[numUniqueEvents];
        this.numTimesEventsSeen = new int[numUniqueEvents];
        int i2 = 0;
        int j = 0;
        while (i2 < numEvents) {
            ComparableEvent evt = (ComparableEvent)eventsToCompare.get(i2);
            if (evt != null) {
                this.numTimesEventsSeen[j] = evt.seen;
                this.outcomeList[j] = evt.outcome;
                this.contexts[j] = evt.predIndexes;
                ++j;
            }
            ++i2;
        }
    }

    static String[] toIndexedStringArray(TObjectIntHashMap labelToIndexMap) {
        final String[] array = new String[labelToIndexMap.size()];
        labelToIndexMap.forEachEntry(new TObjectIntProcedure(){

            public boolean execute(Object str, int index) {
                array[index] = (String)str;
                return true;
            }
        });
        return array;
    }
}

